/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.implementation;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.models.WebPubSubClientAccessToken;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public final class WebPubSubUtil {
    private static final ClientLogger LOGGER = new ClientLogger(WebPubSubUtil.class);
    private static final String TOKEN = "token";

    public static String getToken(BinaryData binaryData) {
        try {
            JsonParser parser = JsonFactory.builder().build().createParser(binaryData.toString());
            while (!parser.isClosed()) {
                JsonToken jsonToken = parser.nextToken();
                if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
                String fieldName = parser.getCurrentName();
                System.out.println(fieldName);
                if (!TOKEN.equals(fieldName)) continue;
                return parser.getValueAsString();
            }
        }
        catch (IOException e) {
            LOGGER.logThrowableAsError((Throwable)new IllegalStateException("Unable to find token in the response", e));
        }
        return null;
    }

    public static WebPubSubClientAccessToken createToken(String token, String endpoint, String hub) {
        endpoint = endpoint.endsWith("/") ? endpoint : endpoint + "/";
        String clientEndpoint = endpoint.replaceFirst("http", "ws");
        String clientUrl = clientEndpoint + "client/hubs/" + hub;
        String url = clientUrl + "?access_token=" + token;
        return new WebPubSubClientAccessToken(token, url);
    }

    private WebPubSubUtil() {
    }
}

