/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.webpubsub.implementation.AzureWebPubSubServiceRestApiImpl;
import reactor.core.publisher.Mono;

public final class HealthApisImpl {
    private final HealthApisService service;
    private final AzureWebPubSubServiceRestApiImpl client;

    HealthApisImpl(AzureWebPubSubServiceRestApiImpl client) {
        this.service = (HealthApisService)RestProxy.create(HealthApisService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getServiceStatusWithResponseAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getServiceStatus(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getServiceStatusWithResponse(RequestOptions requestOptions) {
        return (Response)this.getServiceStatusWithResponseAsync(requestOptions).block();
    }

    @Host(value="{Endpoint}")
    @ServiceInterface(name="AzureWebPubSubServic")
    public static interface HealthApisService {
        @Head(value="/api/health")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> getServiceStatus(@HostParam(value="Endpoint") String var1, @QueryParam(value="api-version") String var2, RequestOptions var3, Context var4);
    }
}

