// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.webpubsub.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.webpubsub.WebPubSubServiceVersion;

/**
 * Initializes a new instance of the WebPubSubServiceClient type.
 */
public final class WebPubSubServiceClientImpl {
    /**
     * HTTP or HTTPS endpoint for the Web PubSub service instance.
     */
    private final String endpoint;

    /**
     * Gets HTTP or HTTPS endpoint for the Web PubSub service instance.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Service version.
     */
    private final WebPubSubServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public WebPubSubServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * The HealthApisImpl object to access its operations.
     */
    private final HealthApisImpl healthApis;

    /**
     * Gets the HealthApisImpl object to access its operations.
     * 
     * @return the HealthApisImpl object.
     */
    public HealthApisImpl getHealthApis() {
        return this.healthApis;
    }

    /**
     * The WebPubSubsImpl object to access its operations.
     */
    private final WebPubSubsImpl webPubSubs;

    /**
     * Gets the WebPubSubsImpl object to access its operations.
     * 
     * @return the WebPubSubsImpl object.
     */
    public WebPubSubsImpl getWebPubSubs() {
        return this.webPubSubs;
    }

    /**
     * Initializes an instance of WebPubSubServiceClient client.
     * 
     * @param endpoint HTTP or HTTPS endpoint for the Web PubSub service instance.
     * @param serviceVersion Service version.
     */
    public WebPubSubServiceClientImpl(String endpoint, WebPubSubServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of WebPubSubServiceClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint HTTP or HTTPS endpoint for the Web PubSub service instance.
     * @param serviceVersion Service version.
     */
    public WebPubSubServiceClientImpl(HttpPipeline httpPipeline, String endpoint,
        WebPubSubServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of WebPubSubServiceClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint HTTP or HTTPS endpoint for the Web PubSub service instance.
     * @param serviceVersion Service version.
     */
    public WebPubSubServiceClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint,
        WebPubSubServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.healthApis = new HealthApisImpl(this);
        this.webPubSubs = new WebPubSubsImpl(this);
    }
}
