// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.webpubsub.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The request object containing targets groups and a connection filter.
 */
@Fluent
public final class AddToGroupsRequest implements JsonSerializable<AddToGroupsRequest> {
    /*
     * A list of groups which target connections will be added into
     */
    private List<String> groups;

    /*
     * An OData filter which target connections satisfy
     */
    private String filter;

    /**
     * Creates an instance of AddToGroupsRequest class.
     */
    public AddToGroupsRequest() {
    }

    /**
     * Get the groups property: A list of groups which target connections will be added into.
     *
     * @return the groups value.
     */
    public List<String> getGroups() {
        return this.groups;
    }

    /**
     * Set the groups property: A list of groups which target connections will be added into.
     *
     * @param groups the groups value to set.
     * @return the AddToGroupsRequest object itself.
     */
    public AddToGroupsRequest setGroups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    /**
     * Get the filter property: An OData filter which target connections satisfy.
     *
     * @return the filter value.
     */
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: An OData filter which target connections satisfy.
     *
     * @param filter the filter value to set.
     * @return the AddToGroupsRequest object itself.
     */
    public AddToGroupsRequest setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("groups", this.groups, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AddToGroupsRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AddToGroupsRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AddToGroupsRequest.
     */
    public static AddToGroupsRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AddToGroupsRequest deserializedAddToGroupsRequest = new AddToGroupsRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("groups".equals(fieldName)) {
                    List<String> groups = reader.readArray(reader1 -> reader1.getString());
                    deserializedAddToGroupsRequest.groups = groups;
                } else if ("filter".equals(fieldName)) {
                    deserializedAddToGroupsRequest.filter = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAddToGroupsRequest;
        });
    }
}
