// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.webpubsub.models;

import com.azure.core.util.ExpandableStringEnum;

import java.util.Collection;

/** Defines values for WebPubSubClientProtocol. */
public final class WebPubSubClientProtocol extends ExpandableStringEnum<WebPubSubClientProtocol> {
    /** Static value DEFAULT for WebPubSubClientProtocol. */
    public static final WebPubSubClientProtocol DEFAULT = fromString("default");

    /** Static value MQTT for WebPubSubClientProtocol. */
    public static final WebPubSubClientProtocol MQTT = fromString("mqtt");

    /**
     * Creates or finds a WebPubSubClientProtocol from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding WebPubSubClientProtocol.
     */
    public static WebPubSubClientProtocol fromString(String name) {
        return fromString(name, WebPubSubClientProtocol.class);
    }

    /**
     * Gets known WebPubSubClientProtocol values.
     *
     * @return known WebPubSubClientProtocol values.
     */
    public static Collection<WebPubSubClientProtocol> values() {
        return values(WebPubSubClientProtocol.class);
    }
}
