// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.webpubsub.models;

import com.azure.core.util.ExpandableStringEnum;

import java.util.Collection;

/** Defines values for WebPubSubPermission. */
public final class WebPubSubPermission extends ExpandableStringEnum<WebPubSubPermission> {
    /** Static value sendToGroup for WebPubSubPermission. */
    public static final WebPubSubPermission SEND_TO_GROUP = fromString("sendToGroup");

    /** Static value joinLeaveGroup for WebPubSubPermission. */
    public static final WebPubSubPermission JOIN_LEAVE_GROUP = fromString("joinLeaveGroup");

    /**
     * Creates a new instance of WebPubSubPermission value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public WebPubSubPermission() {
    }

    /**
     * Creates or finds a WebPubSubPermission from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding WebPubSubPermission.
     */
    public static WebPubSubPermission fromString(String name) {
        return fromString(name, WebPubSubPermission.class);
    }

    /**
     * Gets known WebPubSubPermission values.
     *
     * @return known WebPubSubPermission values.
     */
    public static Collection<WebPubSubPermission> values() {
        return values(WebPubSubPermission.class);
    }
}
