/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.messaging.webpubsub.WebPubSubAuthenticationPolicy;
import com.azure.messaging.webpubsub.WebPubSubServiceAsyncClient;
import com.azure.messaging.webpubsub.WebPubSubServiceClientBuilder;
import com.azure.messaging.webpubsub.implementation.WebPubSubUtil;
import com.azure.messaging.webpubsub.implementation.WebPubSubsImpl;
import com.azure.messaging.webpubsub.implementation.models.AddToGroupsRequest;
import com.azure.messaging.webpubsub.models.GetClientAccessTokenOptions;
import com.azure.messaging.webpubsub.models.WebPubSubClientAccessToken;
import com.azure.messaging.webpubsub.models.WebPubSubClientProtocol;
import com.azure.messaging.webpubsub.models.WebPubSubContentType;
import com.azure.messaging.webpubsub.models.WebPubSubPermission;
import java.util.List;

@ServiceClient(builder=WebPubSubServiceClientBuilder.class)
public final class WebPubSubServiceClient {
    private final WebPubSubsImpl serviceClient;
    private final String endpoint;
    private final AzureKeyCredential keyCredential;
    private final String hub;

    WebPubSubServiceClient(WebPubSubsImpl serviceClient, String hub, String endpoint, AzureKeyCredential keyCredential) {
        this.serviceClient = serviceClient;
        this.endpoint = endpoint;
        this.keyCredential = keyCredential;
        this.hub = hub;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public WebPubSubClientAccessToken getClientAccessToken(GetClientAccessTokenOptions options) {
        String path;
        WebPubSubClientProtocol webPubSubClientProtocol = options.getWebPubSubClientProtocol();
        String string = path = webPubSubClientProtocol.equals((Object)WebPubSubClientProtocol.MQTT) ? "clients/mqtt/hubs/" : "client/hubs/";
        if (this.keyCredential == null) {
            Response<BinaryData> response = this.serviceClient.generateClientTokenWithResponse(this.hub, WebPubSubServiceAsyncClient.configureClientAccessTokenRequestOptions(options));
            return WebPubSubUtil.createToken(WebPubSubUtil.getToken((BinaryData)response.getValue()), this.endpoint, this.hub, path);
        }
        String audience = this.endpoint + (this.endpoint.endsWith("/") ? "" : "/") + path + this.hub;
        String token = WebPubSubAuthenticationPolicy.getAuthenticationToken(audience, options, this.keyCredential);
        return WebPubSubUtil.createToken(token, this.endpoint, this.hub, path);
    }

    Response<BinaryData> generateClientTokenWithResponse(String hub, RequestOptions requestOptions) {
        return this.serviceClient.generateClientTokenWithResponse(hub, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToAllWithResponse(BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString());
        requestOptions.setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this.serviceClient.sendToAllWithResponse(this.hub, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendToAll(String message, WebPubSubContentType contentType) {
        this.sendToAllWithResponse(BinaryData.fromString((String)message), new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToAllWithResponse(BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToAllWithResponse(this.hub, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> connectionExistsWithResponse(String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.connectionExistsWithResponse(this.hub, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> closeConnectionWithResponse(String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.closeConnectionWithResponse(this.hub, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToConnectionWithResponse(String connectionId, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString());
        requestOptions.setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this.serviceClient.sendToConnectionWithResponse(this.hub, connectionId, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendToConnection(String connectionId, String message, WebPubSubContentType contentType) {
        this.sendToConnectionWithResponse(connectionId, BinaryData.fromString((String)message), new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToConnectionWithResponse(String connectionId, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToConnectionWithResponse(this.hub, connectionId, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> groupExistsWithResponse(String group, RequestOptions requestOptions) {
        return this.serviceClient.groupExistsWithResponse(this.hub, group, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToGroupWithResponse(String group, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString());
        requestOptions.setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this.serviceClient.sendToGroupWithResponse(this.hub, group, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendToGroup(String group, String message, WebPubSubContentType contentType) {
        this.sendToGroupWithResponse(group, BinaryData.fromString((String)message), new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToGroupWithResponse(String group, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToGroupWithResponse(this.hub, group, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addConnectionToGroupWithResponse(String group, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.addConnectionToGroupWithResponse(this.hub, group, connectionId, requestOptions);
    }

    private Response<Void> addConnectionsToGroupsWithResponse(BinaryData groupsToAdd, RequestOptions requestOptions) {
        return this.serviceClient.addConnectionsToGroupsWithResponse(this.hub, groupsToAdd, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addConnectionsToGroups(List<String> groups, String filter) {
        AddToGroupsRequest requestBody = new AddToGroupsRequest();
        requestBody.setGroups(groups);
        requestBody.setFilter(filter);
        BinaryData body = BinaryData.fromObject((Object)requestBody);
        this.addConnectionsToGroupsWithResponse(body, new RequestOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeConnectionFromGroupWithResponse(String group, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.removeConnectionFromGroupWithResponse(this.hub, group, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeConnectionFromAllGroupsWithResponse(String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.removeConnectionFromAllGroupsWithResponse(this.hub, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> userExistsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.userExistsWithResponse(this.hub, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToUserWithResponse(String userId, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString());
        requestOptions.setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this.serviceClient.sendToUserWithResponse(this.hub, userId, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendToUser(String userId, String message, WebPubSubContentType contentType) {
        this.sendToUserWithResponse(userId, BinaryData.fromString((String)message), new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToUserWithResponse(String userId, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToUserWithResponse(this.hub, userId, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addUserToGroupWithResponse(String group, String userId, RequestOptions requestOptions) {
        return this.serviceClient.addUserToGroupWithResponse(this.hub, group, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeUserFromGroupWithResponse(String group, String userId, RequestOptions requestOptions) {
        return this.serviceClient.removeUserFromGroupWithResponse(this.hub, group, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeUserFromAllGroupsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.removeUserFromAllGroupsWithResponse(this.hub, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> grantPermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.grantPermissionWithResponse(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> revokePermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.revokePermissionWithResponse(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkPermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.checkPermissionWithResponse(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> closeAllConnectionsWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.closeAllConnectionsWithResponse(this.hub, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> closeGroupConnectionsWithResponse(String group, RequestOptions requestOptions) {
        return this.serviceClient.closeGroupConnectionsWithResponse(this.hub, group, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> closeUserConnectionsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.closeUserConnectionsWithResponse(this.hub, userId, requestOptions);
    }
}

