/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.webpubsub.WebPubSubServiceVersion;
import com.azure.messaging.webpubsub.implementation.WebPubSubServiceClientImpl;
import reactor.core.publisher.Mono;

public final class WebPubSubsImpl {
    private final WebPubSubsService service;
    private final WebPubSubServiceClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(WebPubSubsImpl.class);

    WebPubSubsImpl(WebPubSubServiceClientImpl client) {
        this.service = (WebPubSubsService)RestProxy.create(WebPubSubsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public WebPubSubServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addConnectionsToGroupsWithResponseAsync(String hub, BinaryData groupsToAdd, RequestOptions requestOptions) {
        if (hub == null) {
            return Mono.error((Throwable)LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null.")));
        }
        if (groupsToAdd == null) {
            return Mono.error((Throwable)LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupsToAdd is required and cannot be null.")));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addConnectionsToGroups(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), groupsToAdd, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addConnectionsToGroupsWithResponse(String hub, BinaryData groupsToAdd, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (groupsToAdd == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupsToAdd is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.addConnectionsToGroupsSync(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), groupsToAdd, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeAllConnectionsWithResponseAsync(String hub, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.closeAllConnections(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> closeAllConnectionsWithResponse(String hub, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.closeAllConnectionsSync(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> generateClientTokenWithResponseAsync(String hub, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.generateClientToken(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), "application/json, text/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> generateClientTokenWithResponse(String hub, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        return this.service.generateClientTokenSync(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), "application/json, text/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeConnectionsFromGroupsWithResponseAsync(String hub, BinaryData groupsToRemove, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (groupsToRemove == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupsToRemove is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeConnectionsFromGroups(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), groupsToRemove, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeConnectionsFromGroupsWithResponse(String hub, BinaryData groupsToRemove, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (groupsToRemove == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupsToRemove is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.removeConnectionsFromGroupsSync(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), groupsToRemove, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToAllWithResponseAsync(String hub, String contentType, BinaryData message, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (contentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.sendToAll(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), contentType, message, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToAllWithResponse(String hub, String contentType, BinaryData message, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (contentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.sendToAllSync(this.client.getEndpoint(), hub, this.client.getServiceVersion().getVersion(), contentType, message, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeConnectionWithResponseAsync(String hub, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.closeConnection(this.client.getEndpoint(), hub, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> closeConnectionWithResponse(String hub, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.closeConnectionSync(this.client.getEndpoint(), hub, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> connectionExistsWithResponseAsync(String hub, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.connectionExists(this.client.getEndpoint(), hub, connectionId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> connectionExistsWithResponse(String hub, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.connectionExistsSync(this.client.getEndpoint(), hub, connectionId, this.client.getServiceVersion().getVersion(), requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToConnectionWithResponseAsync(String hub, String connectionId, String contentType, BinaryData message, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        if (contentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.sendToConnection(this.client.getEndpoint(), hub, connectionId, this.client.getServiceVersion().getVersion(), contentType, message, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToConnectionWithResponse(String hub, String connectionId, String contentType, BinaryData message, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        if (contentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.sendToConnectionSync(this.client.getEndpoint(), hub, connectionId, this.client.getServiceVersion().getVersion(), contentType, message, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeConnectionFromAllGroupsWithResponseAsync(String hub, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeConnectionFromAllGroups(this.client.getEndpoint(), hub, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeConnectionFromAllGroupsWithResponse(String hub, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.removeConnectionFromAllGroupsSync(this.client.getEndpoint(), hub, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> groupExistsWithResponseAsync(String hub, String group, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.groupExists(this.client.getEndpoint(), hub, group, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> groupExistsWithResponse(String hub, String group, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        return this.service.groupExistsSync(this.client.getEndpoint(), hub, group, this.client.getServiceVersion().getVersion(), requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeGroupConnectionsWithResponseAsync(String hub, String group, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.closeGroupConnections(this.client.getEndpoint(), hub, group, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> closeGroupConnectionsWithResponse(String hub, String group, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.closeGroupConnectionsSync(this.client.getEndpoint(), hub, group, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToGroupWithResponseAsync(String hub, String group, String contentType, BinaryData message, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (contentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.sendToGroup(this.client.getEndpoint(), hub, group, this.client.getServiceVersion().getVersion(), contentType, message, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToGroupWithResponse(String hub, String group, String contentType, BinaryData message, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (contentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.sendToGroupSync(this.client.getEndpoint(), hub, group, this.client.getServiceVersion().getVersion(), contentType, message, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeConnectionFromGroupWithResponseAsync(String hub, String group, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeConnectionFromGroup(this.client.getEndpoint(), hub, group, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeConnectionFromGroupWithResponse(String hub, String group, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.removeConnectionFromGroupSync(this.client.getEndpoint(), hub, group, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addConnectionToGroupWithResponseAsync(String hub, String group, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addConnectionToGroup(this.client.getEndpoint(), hub, group, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addConnectionToGroupWithResponse(String hub, String group, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.addConnectionToGroupSync(this.client.getEndpoint(), hub, group, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokePermissionWithResponseAsync(String hub, String permission, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.revokePermission(this.client.getEndpoint(), hub, permission, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> revokePermissionWithResponse(String hub, String permission, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.revokePermissionSync(this.client.getEndpoint(), hub, permission, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkPermissionWithResponseAsync(String hub, String permission, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.checkPermission(this.client.getEndpoint(), hub, permission, connectionId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkPermissionWithResponse(String hub, String permission, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.checkPermissionSync(this.client.getEndpoint(), hub, permission, connectionId, this.client.getServiceVersion().getVersion(), requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> grantPermissionWithResponseAsync(String hub, String permission, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.grantPermission(this.client.getEndpoint(), hub, permission, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> grantPermissionWithResponse(String hub, String permission, String connectionId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.grantPermissionSync(this.client.getEndpoint(), hub, permission, connectionId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> userExistsWithResponseAsync(String hub, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.userExists(this.client.getEndpoint(), hub, userId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> userExistsWithResponse(String hub, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return this.service.userExistsSync(this.client.getEndpoint(), hub, userId, this.client.getServiceVersion().getVersion(), requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeUserConnectionsWithResponseAsync(String hub, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.closeUserConnections(this.client.getEndpoint(), hub, userId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> closeUserConnectionsWithResponse(String hub, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.closeUserConnectionsSync(this.client.getEndpoint(), hub, userId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToUserWithResponseAsync(String hub, String userId, String contentType, BinaryData message, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (contentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.sendToUser(this.client.getEndpoint(), hub, userId, this.client.getServiceVersion().getVersion(), contentType, message, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendToUserWithResponse(String hub, String userId, String contentType, BinaryData message, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (contentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.sendToUserSync(this.client.getEndpoint(), hub, userId, this.client.getServiceVersion().getVersion(), contentType, message, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeUserFromAllGroupsWithResponseAsync(String hub, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeUserFromAllGroups(this.client.getEndpoint(), hub, userId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeUserFromAllGroupsWithResponse(String hub, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.removeUserFromAllGroupsSync(this.client.getEndpoint(), hub, userId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeUserFromGroupWithResponseAsync(String hub, String group, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeUserFromGroup(this.client.getEndpoint(), hub, group, userId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeUserFromGroupWithResponse(String hub, String group, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.removeUserFromGroupSync(this.client.getEndpoint(), hub, group, userId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addUserToGroupWithResponseAsync(String hub, String group, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addUserToGroup(this.client.getEndpoint(), hub, group, userId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addUserToGroupWithResponse(String hub, String group, String userId, RequestOptions requestOptions) {
        if (hub == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (userId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.addUserToGroupSync(this.client.getEndpoint(), hub, group, userId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureWebPubSubServic")
    public static interface WebPubSubsService {
        @Post(value="/api/hubs/{hub}/:addToGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addConnectionsToGroups(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/api/hubs/{hub}/:addToGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addConnectionsToGroupsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/api/hubs/{hub}/:closeConnections")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> closeAllConnections(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/api/hubs/{hub}/:closeConnections")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> closeAllConnectionsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/api/hubs/{hub}/:generateToken")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> generateClientToken(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/api/hubs/{hub}/:generateToken")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> generateClientTokenSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/api/hubs/{hub}/:removeFromGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeConnectionsFromGroups(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/api/hubs/{hub}/:removeFromGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeConnectionsFromGroupsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/api/hubs/{hub}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> sendToAll(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Content-Type") String var4, @BodyParam(value="application/octet-stream") BinaryData var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/api/hubs/{hub}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> sendToAllSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Content-Type") String var4, @BodyParam(value="application/octet-stream") BinaryData var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/api/hubs/{hub}/connections/{connectionId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> closeConnection(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/api/hubs/{hub}/connections/{connectionId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> closeConnectionSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Head(value="/api/hubs/{hub}/connections/{connectionId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Boolean>> connectionExists(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Head(value="/api/hubs/{hub}/connections/{connectionId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Boolean> connectionExistsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Post(value="/api/hubs/{hub}/connections/{connectionId}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> sendToConnection(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") String var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Post(value="/api/hubs/{hub}/connections/{connectionId}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> sendToConnectionSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") String var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Delete(value="/api/hubs/{hub}/connections/{connectionId}/groups")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeConnectionFromAllGroups(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/api/hubs/{hub}/connections/{connectionId}/groups")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeConnectionFromAllGroupsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Head(value="/api/hubs/{hub}/groups/{group}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Boolean>> groupExists(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Head(value="/api/hubs/{hub}/groups/{group}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Boolean> groupExistsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Post(value="/api/hubs/{hub}/groups/{group}/:closeConnections")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> closeGroupConnections(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/api/hubs/{hub}/groups/{group}/:closeConnections")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> closeGroupConnectionsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/api/hubs/{hub}/groups/{group}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> sendToGroup(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") String var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Post(value="/api/hubs/{hub}/groups/{group}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> sendToGroupSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") String var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Delete(value="/api/hubs/{hub}/groups/{group}/connections/{connectionId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeConnectionFromGroup(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/api/hubs/{hub}/groups/{group}/connections/{connectionId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeConnectionFromGroupSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Put(value="/api/hubs/{hub}/groups/{group}/connections/{connectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addConnectionToGroup(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Put(value="/api/hubs/{hub}/groups/{group}/connections/{connectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addConnectionToGroupSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> revokePermission(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> revokePermissionSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Head(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Boolean>> checkPermission(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Head(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Boolean> checkPermissionSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Put(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> grantPermission(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Put(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> grantPermissionSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Head(value="/api/hubs/{hub}/users/{userId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Boolean>> userExists(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Head(value="/api/hubs/{hub}/users/{userId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Boolean> userExistsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Post(value="/api/hubs/{hub}/users/{userId}/:closeConnections")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> closeUserConnections(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/api/hubs/{hub}/users/{userId}/:closeConnections")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> closeUserConnectionsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/api/hubs/{hub}/users/{userId}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> sendToUser(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") String var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Post(value="/api/hubs/{hub}/users/{userId}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> sendToUserSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") String var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Delete(value="/api/hubs/{hub}/users/{userId}/groups")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeUserFromAllGroups(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/api/hubs/{hub}/users/{userId}/groups")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeUserFromAllGroupsSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/api/hubs/{hub}/users/{userId}/groups/{group}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeUserFromGroup(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="userId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/api/hubs/{hub}/users/{userId}/groups/{group}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeUserFromGroupSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="userId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Put(value="/api/hubs/{hub}/users/{userId}/groups/{group}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addUserToGroup(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="userId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Put(value="/api/hubs/{hub}/users/{userId}/groups/{group}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addUserToGroupSync(@HostParam(value="endpoint") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="userId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);
    }
}

