/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.models.GetClientAccessTokenOptions;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import reactor.core.publisher.Mono;

public final class WebPubSubAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(WebPubSubAuthenticationPolicy.class);
    private static final Duration DEFAULT_EXPIRATION = Duration.ofHours(1L);
    private final AzureKeyCredential credential;

    public WebPubSubAuthenticationPolicy(AzureKeyCredential credential) {
        this.credential = credential;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return Mono.fromRunnable(() -> {
            String audienceUrl = context.getHttpRequest().getUrl().toString();
            String token = WebPubSubAuthenticationPolicy.getAuthenticationToken(audienceUrl, null, this.credential);
            if (token != null) {
                context.getHttpRequest().setHeader(HttpHeaderName.AUTHORIZATION, "Bearer " + token);
            }
        }).then(next.process());
    }

    static String getAuthenticationToken(String audienceUrl, GetClientAccessTokenOptions options, AzureKeyCredential credential) {
        try {
            Duration expiresAfter = DEFAULT_EXPIRATION;
            JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder().audience(audienceUrl);
            if (options != null) {
                expiresAfter = options.getExpiresAfter() == null ? expiresAfter : options.getExpiresAfter();
                String userId = options.getUserId();
                if (!CoreUtils.isNullOrEmpty(options.getRoles())) {
                    claimsBuilder.claim("role", options.getRoles());
                }
                if (!CoreUtils.isNullOrEmpty((CharSequence)userId)) {
                    claimsBuilder.subject(userId);
                }
                if (!CoreUtils.isNullOrEmpty(options.getGroups())) {
                    claimsBuilder.claim("webpubsub.group", options.getGroups());
                }
            }
            claimsBuilder.expirationTime(Date.from(LocalDateTime.now().plus(expiresAfter).atZone(ZoneId.systemDefault()).toInstant()));
            JWTClaimsSet claims = claimsBuilder.build();
            MACSigner signer = new MACSigner(credential.getKey().getBytes(StandardCharsets.UTF_8));
            SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claims);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (JOSEException e) {
            LOGGER.logThrowableAsError((Throwable)e);
            return null;
        }
    }
}

