/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mixedreality.authentication;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.mixedreality.authentication.AuthenticationEndpoint;
import com.azure.mixedreality.authentication.MixedRealityAccountKeyCredential;
import com.azure.mixedreality.authentication.MixedRealityStsAsyncClient;
import com.azure.mixedreality.authentication.MixedRealityStsClient;
import com.azure.mixedreality.authentication.MixedRealityStsServiceVersion;
import com.azure.mixedreality.authentication.implementation.MixedRealityStsRestClientImpl;
import com.azure.mixedreality.authentication.implementation.MixedRealityStsRestClientImplBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@ServiceClientBuilder(serviceClients={MixedRealityStsClient.class, MixedRealityStsAsyncClient.class})
public final class MixedRealityStsClientBuilder {
    private static final String MIXED_REALITY_STS_PROPERTIES = "azure-mixedreality-authentication.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final List<HttpPipelinePolicy> customPolicies = new ArrayList<HttpPipelinePolicy>();
    private final ClientLogger logger = new ClientLogger(MixedRealityStsClientBuilder.class);
    private String accountDomain;
    private String accountId;
    private MixedRealityStsServiceVersion apiVersion;
    private ClientOptions clientOptions;
    private Configuration configuration;
    private String endpoint;
    private HttpClient httpClient;
    private AzureKeyCredential keyCredential;
    private HttpLogOptions logOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private RetryPolicy retryPolicy;
    private TokenCredential tokenCredential;

    public MixedRealityStsClientBuilder accountDomain(String accountDomain) {
        Objects.requireNonNull(accountDomain, "'accountDomain' cannot be null.");
        if (accountDomain.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'accountDomain' cannot be an empty string."));
        }
        this.accountDomain = accountDomain;
        return this;
    }

    public MixedRealityStsClientBuilder accountId(String accountId) {
        Objects.requireNonNull(accountId, "'accountId' cannot be null.");
        if (accountId.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'accountId' cannot be an empty string."));
        }
        this.accountId = accountId;
        return this;
    }

    public MixedRealityStsClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.customPolicies.add(Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null."));
        return this;
    }

    public MixedRealityStsClient buildClient() {
        return new MixedRealityStsClient(this.buildAsyncClient());
    }

    public MixedRealityStsAsyncClient buildAsyncClient() {
        String endpoint;
        UUID accountId;
        Objects.requireNonNull(this.accountId, "The 'accountId' has not been set and is required.");
        Objects.requireNonNull(this.accountDomain, "The 'accountDomain' has not been set and is required.");
        try {
            accountId = UUID.fromString(this.accountId);
        }
        catch (IllegalArgumentException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("The 'accountId' must be a UUID formatted value."));
        }
        if (this.endpoint != null) {
            try {
                new URL(this.endpoint);
                endpoint = this.endpoint;
            }
            catch (MalformedURLException ex) {
                throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("The 'endpoint' must be a valid URL."));
            }
        } else {
            endpoint = AuthenticationEndpoint.constructFromDomain(this.accountDomain);
        }
        if (this.pipeline == null) {
            if (this.tokenCredential != null && this.keyCredential != null) {
                throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Only a single type of credential may be specified."));
            }
            if (this.tokenCredential == null && this.keyCredential != null) {
                this.tokenCredential = new MixedRealityAccountKeyCredential(accountId, this.keyCredential);
            }
            Objects.requireNonNull(this.tokenCredential, "The 'credential' has not been set and is required.");
            String scope = AuthenticationEndpoint.constructScope(endpoint);
            BearerTokenAuthenticationPolicy authPolicy = new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{scope});
            this.pipeline = this.createHttpPipeline(this.httpClient, (HttpPipelinePolicy)authPolicy, this.customPolicies);
        }
        MixedRealityStsServiceVersion version = this.apiVersion != null ? this.apiVersion : MixedRealityStsServiceVersion.getLatest();
        MixedRealityStsRestClientImpl serviceClient = new MixedRealityStsRestClientImplBuilder().apiVersion(version.getVersion()).pipeline(this.pipeline).host(endpoint).buildClient();
        return new MixedRealityStsAsyncClient(accountId, serviceClient);
    }

    public MixedRealityStsClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public MixedRealityStsClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        return this;
    }

    public MixedRealityStsClientBuilder credential(AzureKeyCredential keyCredential) {
        this.keyCredential = Objects.requireNonNull(keyCredential, "'keyCredential' cannot be null.");
        return this;
    }

    public MixedRealityStsClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public MixedRealityStsClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public MixedRealityStsClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public MixedRealityStsClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public MixedRealityStsClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public MixedRealityStsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public MixedRealityStsClientBuilder serviceVersion(MixedRealityStsServiceVersion version) {
        this.apiVersion = version;
        return this;
    }

    private void applyRequiredPolicies(List<HttpPipelinePolicy> policies) {
        RetryPolicy retryPolicy = this.retryPolicy != null ? this.retryPolicy : new RetryPolicy();
        policies.add((HttpPipelinePolicy)this.getUserAgentPolicy());
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            policies.add((HttpPipelinePolicy)new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        policies.add((HttpPipelinePolicy)retryPolicy);
        policies.add((HttpPipelinePolicy)new CookiePolicy());
        policies.add((HttpPipelinePolicy)new HttpLoggingPolicy(this.logOptions));
    }

    private HttpPipeline createHttpPipeline(HttpClient httpClient, HttpPipelinePolicy authorizationPolicy, List<HttpPipelinePolicy> additionalPolicies) {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(authorizationPolicy);
        this.applyRequiredPolicies(policies);
        if (additionalPolicies != null && additionalPolicies.size() > 0) {
            policies.addAll(additionalPolicies);
        }
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    private UserAgentPolicy getUserAgentPolicy() {
        Map properties = CoreUtils.getProperties((String)MIXED_REALITY_STS_PROPERTIES);
        String clientName = properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = this.clientOptions == null ? this.logOptions.getApplicationId() : this.clientOptions.getApplicationId();
        return new UserAgentPolicy(applicationId, clientName, clientVersion, this.configuration);
    }
}

