// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.mixedreality.authentication.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.mixedreality.authentication.implementation.models.GetTokenResponse;
import com.azure.mixedreality.authentication.implementation.models.TokenRequestOptions;
import java.util.UUID;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the MixedRealityStsRestClient type. */
public final class MixedRealityStsRestClientImpl {
    /** The proxy service used to perform REST calls. */
    private final MixedRealityStsRestClientService service;

    /** server parameter. */
    private final String host;

    /**
     * Gets server parameter.
     *
     * @return the host value.
     */
    public String getHost() {
        return this.host;
    }

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of MixedRealityStsRestClient client.
     *
     * @param host server parameter.
     * @param apiVersion Api Version.
     */
    MixedRealityStsRestClientImpl(String host, String apiVersion) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                host,
                apiVersion);
    }

    /**
     * Initializes an instance of MixedRealityStsRestClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param host server parameter.
     * @param apiVersion Api Version.
     */
    MixedRealityStsRestClientImpl(HttpPipeline httpPipeline, String host, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), host, apiVersion);
    }

    /**
     * Initializes an instance of MixedRealityStsRestClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param host server parameter.
     * @param apiVersion Api Version.
     */
    MixedRealityStsRestClientImpl(
            HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String host, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.host = host;
        this.apiVersion = apiVersion;
        this.service =
                RestProxy.create(
                        MixedRealityStsRestClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for MixedRealityStsRestClient to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MixedRealityStsRestC")
    public interface MixedRealityStsRestClientService {
        @Get("/Accounts/{accountId}/token")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<GetTokenResponse> getToken(
                @HostParam("$host") String host,
                @PathParam("accountId") UUID accountId,
                @HeaderParam("X-MRC-CV") String clientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Gets an access token to be used with Mixed Reality services.
     *
     * @param accountId The Mixed Reality account identifier.
     * @param tokenRequestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an access token to be used with Mixed Reality services.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GetTokenResponse> getTokenWithResponseAsync(
            UUID accountId, TokenRequestOptions tokenRequestOptions, Context context) {
        final String accept = "application/json";
        String clientRequestIdInternal = null;
        if (tokenRequestOptions != null) {
            clientRequestIdInternal = tokenRequestOptions.getClientRequestId();
        }
        String clientRequestId = clientRequestIdInternal;
        return service.getToken(this.getHost(), accountId, clientRequestId, this.getApiVersion(), accept, context);
    }
}
