/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mixedreality.authentication;

import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;

class JsonWebToken {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    JsonWebToken() {
    }

    public static OffsetDateTime retrieveExpiration(String jwtValue) {
        JsonNode rootNode;
        if (CoreUtils.isNullOrEmpty((CharSequence)jwtValue)) {
            throw new IllegalArgumentException("Value cannot be null or empty: 'jwtValue'.");
        }
        String[] jwtParts = jwtValue.split("[.]");
        if (jwtParts.length < 2) {
            return null;
        }
        String jwtPayloadEncoded = jwtParts[1];
        if (CoreUtils.isNullOrEmpty((CharSequence)jwtPayloadEncoded)) {
            return null;
        }
        byte[] jwtPayloadDecodedData = Base64.getDecoder().decode(jwtPayloadEncoded);
        try {
            rootNode = MAPPER.readTree(jwtPayloadDecodedData);
        }
        catch (IOException exception) {
            return null;
        }
        if (!rootNode.has("exp")) {
            return null;
        }
        long expirationValue = rootNode.get("exp").asLong();
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(expirationValue), ZoneOffset.UTC);
    }
}

