/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mixedreality.remoterendering;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.mixedreality.remoterendering.RemoteRenderingClientBuilder;
import com.azure.mixedreality.remoterendering.implementation.MixedRealityRemoteRenderingImpl;
import com.azure.mixedreality.remoterendering.implementation.models.Conversion;
import com.azure.mixedreality.remoterendering.implementation.models.ConversionInputSettings;
import com.azure.mixedreality.remoterendering.implementation.models.ConversionOutputSettings;
import com.azure.mixedreality.remoterendering.implementation.models.ConversionSettings;
import com.azure.mixedreality.remoterendering.implementation.models.CreateConversionSettings;
import com.azure.mixedreality.remoterendering.implementation.models.CreateSessionSettings;
import com.azure.mixedreality.remoterendering.implementation.models.Error;
import com.azure.mixedreality.remoterendering.implementation.models.SessionProperties;
import com.azure.mixedreality.remoterendering.implementation.models.SessionSize;
import com.azure.mixedreality.remoterendering.implementation.models.UpdateSessionSettings;
import com.azure.mixedreality.remoterendering.models.AssetConversion;
import com.azure.mixedreality.remoterendering.models.AssetConversionOptions;
import com.azure.mixedreality.remoterendering.models.AssetConversionStatus;
import com.azure.mixedreality.remoterendering.models.BeginSessionOptions;
import com.azure.mixedreality.remoterendering.models.RemoteRenderingServiceError;
import com.azure.mixedreality.remoterendering.models.RenderingSession;
import com.azure.mixedreality.remoterendering.models.RenderingSessionSize;
import com.azure.mixedreality.remoterendering.models.RenderingSessionStatus;
import com.azure.mixedreality.remoterendering.models.UpdateSessionOptions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=RemoteRenderingClientBuilder.class, isAsync=true)
public final class RemoteRenderingAsyncClient {
    private static final Duration CONVERSION_POLLING_INTERVAL = Duration.ofSeconds(10L);
    private static final Duration STANDARD_SESSION_POLLING_INTERVAL = Duration.ofSeconds(2L);
    private static final Duration DEFAULT_SESSION_POLLING_INTERVAL = Duration.ofSeconds(10L);
    private final ClientLogger logger = new ClientLogger(RemoteRenderingAsyncClient.class);
    private final UUID accountId;
    private final MixedRealityRemoteRenderingImpl impl;

    RemoteRenderingAsyncClient(MixedRealityRemoteRenderingImpl impl, UUID accountId) {
        this.accountId = accountId;
        this.impl = impl;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<RenderingSession, RenderingSession> beginSession(String sessionId) {
        return this.beginSession(sessionId, new BeginSessionOptions());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<RenderingSession, RenderingSession> beginSession(String sessionId, BeginSessionOptions options) {
        return this.beginSessionInternal(sessionId, options, Context.NONE);
    }

    PollerFlux<RenderingSession, RenderingSession> beginSessionInternal(String sessionId, BeginSessionOptions options, Context context) {
        Objects.requireNonNull(sessionId, "'sessionId' cannot be null.");
        Objects.requireNonNull(options, "'options' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        if (sessionId.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sessionId' cannot be an empty string."));
        }
        return new PollerFlux(options.getSize() == RenderingSessionSize.STANDARD ? STANDARD_SESSION_POLLING_INTERVAL : DEFAULT_SESSION_POLLING_INTERVAL, pollingContext -> this.impl.getRemoteRenderings().createSessionWithResponseAsync(this.accountId, sessionId, ModelTranslator.toGenerated(options), context).map(r -> ModelTranslator.fromGenerated(r.getValue())), pollingContext -> {
            Mono response = this.impl.getRemoteRenderings().getSessionWithResponseAsync(this.accountId, sessionId, context).map(r -> ModelTranslator.fromGenerated((SessionProperties)r.getValue()));
            return response.map(session -> {
                RenderingSessionStatus sessionStatus = session.getStatus();
                LongRunningOperationStatus lroStatus = sessionStatus == RenderingSessionStatus.STARTING ? LongRunningOperationStatus.IN_PROGRESS : (sessionStatus == RenderingSessionStatus.ERROR ? LongRunningOperationStatus.FAILED : (sessionStatus == RenderingSessionStatus.READY ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (sessionStatus == RenderingSessionStatus.STOPPED ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.FAILED)));
                return new PollResponse(lroStatus, session);
            });
        }, (pollingContext, pollResponse) -> this.impl.getRemoteRenderings().stopSessionWithResponseAsync(this.accountId, sessionId, context).then(Mono.just((Object)((RenderingSession)pollingContext.getLatestResponse().getValue()))), pollingContext -> Mono.just((Object)((RenderingSession)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RenderingSession> getSession(String sessionId) {
        return this.getSessionWithResponse(sessionId).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RenderingSession>> getSessionWithResponse(String sessionId) {
        try {
            return FluxUtil.withContext(context -> this.getSessionInternal(sessionId, (Context)context));
        }
        catch (RuntimeException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
    }

    Mono<Response<RenderingSession>> getSessionInternal(String sessionId, Context context) {
        Objects.requireNonNull(sessionId, "'sessionId' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        if (sessionId.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sessionId' cannot be an empty string."));
        }
        return this.impl.getRemoteRenderings().getSessionWithResponseAsync(this.accountId, sessionId, context).map(x$0 -> ModelTranslator.fromGenerated(x$0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RenderingSession> updateSession(String sessionId, UpdateSessionOptions options) {
        return this.updateSessionWithResponse(sessionId, options).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RenderingSession>> updateSessionWithResponse(String sessionId, UpdateSessionOptions options) {
        try {
            return FluxUtil.withContext(context -> this.updateSessionInternal(sessionId, options, (Context)context));
        }
        catch (RuntimeException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
    }

    Mono<Response<RenderingSession>> updateSessionInternal(String sessionId, UpdateSessionOptions options, Context context) {
        Objects.requireNonNull(sessionId, "'sessionId' cannot be null.");
        Objects.requireNonNull(options, "'options' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        if (sessionId.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sessionId' cannot be an empty string."));
        }
        return this.impl.getRemoteRenderings().updateSessionWithResponseAsync(this.accountId, sessionId, ModelTranslator.toGenerated(options), context).map(x$0 -> ModelTranslator.fromGenerated(x$0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> endSession(String sessionId) {
        return this.endSessionWithResponse(sessionId).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> endSessionWithResponse(String sessionId) {
        try {
            return FluxUtil.withContext(context -> this.endSessionInternal(sessionId, (Context)context));
        }
        catch (RuntimeException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
    }

    Mono<Response<Void>> endSessionInternal(String sessionId, Context context) {
        Objects.requireNonNull(sessionId, "'sessionId' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        if (sessionId.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sessionId' cannot be an empty string."));
        }
        return this.impl.getRemoteRenderings().stopSessionWithResponseAsync(this.accountId, sessionId, context).map(r -> r);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RenderingSession> listSessions() {
        return this.listSessionsInternal(Context.NONE);
    }

    PagedFlux<RenderingSession> listSessionsInternal(Context context) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        return new PagedFlux(() -> this.impl.getRemoteRenderings().listSessionsSinglePageAsync(this.accountId, context).map(p -> new PagedResponseBase(p.getRequest(), p.getStatusCode(), p.getHeaders(), p.getValue().stream().map(x$0 -> ModelTranslator.fromGenerated(x$0)).collect(Collectors.toList()), (String)p.getContinuationToken(), null)), continuationToken -> this.impl.getRemoteRenderings().listSessionsNextSinglePageAsync((String)continuationToken, context).map(p -> new PagedResponseBase(p.getRequest(), p.getStatusCode(), p.getHeaders(), p.getValue().stream().map(x$0 -> ModelTranslator.fromGenerated(x$0)).collect(Collectors.toList()), (String)p.getContinuationToken(), null)));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AssetConversion, AssetConversion> beginConversion(String conversionId, AssetConversionOptions options) {
        return this.beginConversionInternal(conversionId, options, Context.NONE);
    }

    PollerFlux<AssetConversion, AssetConversion> beginConversionInternal(String conversionId, AssetConversionOptions options, Context context) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        return new PollerFlux(CONVERSION_POLLING_INTERVAL, pollingContext -> this.impl.getRemoteRenderings().createConversionWithResponseAsync(this.accountId, conversionId, new CreateConversionSettings(ModelTranslator.toGenerated(options)), context).map(c -> ModelTranslator.fromGenerated(c.getValue())), pollingContext -> {
            Mono response = this.impl.getRemoteRenderings().getConversionWithResponseAsync(this.accountId, conversionId, context).map(c -> ModelTranslator.fromGenerated(c.getValue()));
            return response.map(conversion -> {
                AssetConversionStatus conversionStatus = conversion.getStatus();
                LongRunningOperationStatus lroStatus = conversionStatus == AssetConversionStatus.RUNNING || conversionStatus == AssetConversionStatus.NOT_STARTED ? LongRunningOperationStatus.IN_PROGRESS : (conversionStatus == AssetConversionStatus.FAILED ? LongRunningOperationStatus.FAILED : (conversionStatus == AssetConversionStatus.SUCCEEDED ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (conversionStatus == AssetConversionStatus.CANCELLED ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.FAILED)));
                return new PollResponse(lroStatus, conversion);
            });
        }, (pollingContext, pollResponse) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported.")), pollingContext -> Mono.just((Object)((AssetConversion)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AssetConversion> getConversion(String conversionId) {
        return this.getConversionWithResponse(conversionId).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AssetConversion>> getConversionWithResponse(String conversionId) {
        try {
            return FluxUtil.withContext(context -> this.getConversionInternal(conversionId, (Context)context));
        }
        catch (RuntimeException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
    }

    Mono<Response<AssetConversion>> getConversionInternal(String conversionId, Context context) {
        Objects.requireNonNull(conversionId, "'conversionId' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        if (conversionId.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'conversionId' cannot be an empty string."));
        }
        return this.impl.getRemoteRenderings().getConversionWithResponseAsync(this.accountId, conversionId, context).map(x$0 -> ModelTranslator.fromGenerated(x$0));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AssetConversion> listConversions() {
        return this.listConversionsInternal(Context.NONE);
    }

    PagedFlux<AssetConversion> listConversionsInternal(Context context) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        return new PagedFlux(() -> this.impl.getRemoteRenderings().listConversionsSinglePageAsync(this.accountId, context).map(p -> new PagedResponseBase(p.getRequest(), p.getStatusCode(), p.getHeaders(), p.getValue().stream().map(x$0 -> ModelTranslator.fromGenerated(x$0)).collect(Collectors.toList()), (String)p.getContinuationToken(), null)), continuationToken -> this.impl.getRemoteRenderings().listConversionsNextSinglePageAsync((String)continuationToken, context).map(p -> new PagedResponseBase(p.getRequest(), p.getStatusCode(), p.getHeaders(), p.getValue().stream().map(x$0 -> ModelTranslator.fromGenerated(x$0)).collect(Collectors.toList()), (String)p.getContinuationToken(), null)));
    }

    private static class ModelTranslator {
        private ModelTranslator() {
        }

        private static <T, Y> Response<T> fromGenerated(final Response<Y> response) {
            if (response == null) {
                return null;
            }
            return new Response<T>(){
                private final T value;
                {
                    this.value = ModelTranslator.fromGeneratedGeneric(response.getValue());
                }

                public int getStatusCode() {
                    return response.getStatusCode();
                }

                public HttpHeaders getHeaders() {
                    return response.getHeaders();
                }

                public HttpRequest getRequest() {
                    return response.getRequest();
                }

                public T getValue() {
                    return this.value;
                }
            };
        }

        private static <T, Y> T fromGeneratedGeneric(Y value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Conversion) {
                return (T)ModelTranslator.fromGenerated((Conversion)value);
            }
            if (value instanceof SessionProperties) {
                return (T)ModelTranslator.fromGenerated((SessionProperties)value);
            }
            if (value instanceof Error) {
                return (T)ModelTranslator.fromGenerated((Error)value);
            }
            if (value instanceof ConversionSettings) {
                return (T)ModelTranslator.fromGenerated((ConversionSettings)value);
            }
            return null;
        }

        private static AssetConversion fromGenerated(Conversion conversion) {
            if (conversion == null) {
                return null;
            }
            return new AssetConversion(conversion.getId(), ModelTranslator.fromGenerated(conversion.getSettings()), conversion.getOutput() != null ? conversion.getOutput().getOutputAssetUri() : null, ModelTranslator.fromGenerated(conversion.getError()), AssetConversionStatus.fromString(conversion.getStatus().toString()), conversion.getCreationTime());
        }

        private static RenderingSession fromGenerated(SessionProperties sessionProperties) {
            if (sessionProperties == null) {
                return null;
            }
            return new RenderingSession(sessionProperties.getId(), Optional.ofNullable(sessionProperties.getArrInspectorPort()).orElse(0), Optional.ofNullable(sessionProperties.getHandshakePort()).orElse(0), Duration.ofMinutes(Optional.ofNullable(sessionProperties.getElapsedTimeMinutes()).orElse(0).intValue()), sessionProperties.getHostname(), Duration.ofMinutes(Optional.ofNullable(sessionProperties.getMaxLeaseTimeMinutes()).orElse(0).intValue()), RenderingSessionSize.fromString(sessionProperties.getSize().toString()), RenderingSessionStatus.fromString(sessionProperties.getStatus().toString()), Optional.ofNullable(sessionProperties.getTeraflops()).orElse(Float.valueOf(0.0f)).floatValue(), ModelTranslator.fromGenerated(sessionProperties.getError()), sessionProperties.getCreationTime());
        }

        private static RemoteRenderingServiceError fromGenerated(Error error) {
            if (error == null) {
                return null;
            }
            return new RemoteRenderingServiceError(error.getCode(), error.getMessage(), error.getTarget(), ModelTranslator.fromGenerated(error.getInnerError()), error.getDetails() != null ? error.getDetails().stream().map(ModelTranslator::fromGenerated).collect(Collectors.toList()) : null);
        }

        private static AssetConversionOptions fromGenerated(ConversionSettings settings) {
            if (settings == null) {
                return null;
            }
            return new AssetConversionOptions().setInputBlobPrefix(settings.getInputLocation().getBlobPrefix()).setInputRelativeAssetPath(settings.getInputLocation().getRelativeInputAssetPath()).setInputStorageContainerReadListSas(settings.getInputLocation().getStorageContainerReadListSas()).setInputStorageContainerUrl(settings.getInputLocation().getStorageContainerUri()).setOutputAssetFilename(settings.getOutputLocation().getOutputAssetFilename()).setOutputBlobPrefix(settings.getOutputLocation().getBlobPrefix()).setOutputStorageContainerUrl(settings.getOutputLocation().getStorageContainerUri()).setOutputStorageContainerWriteSas(settings.getOutputLocation().getStorageContainerWriteSas());
        }

        private static ConversionSettings toGenerated(AssetConversionOptions conversionOptions) {
            if (conversionOptions == null) {
                return null;
            }
            return new ConversionSettings(new ConversionInputSettings(conversionOptions.getInputStorageContainerUrl(), conversionOptions.getInputRelativeAssetPath()).setStorageContainerReadListSas(conversionOptions.getInputStorageContainerReadListSas()).setBlobPrefix(conversionOptions.getInputBlobPrefix()), new ConversionOutputSettings(conversionOptions.getOutputStorageContainerUrl()).setStorageContainerWriteSas(conversionOptions.getOutputStorageContainerWriteSas()).setBlobPrefix(conversionOptions.getOutputBlobPrefix()).setOutputAssetFilename(conversionOptions.getOutputAssetFilename()));
        }

        private static UpdateSessionSettings toGenerated(UpdateSessionOptions options) {
            if (options == null) {
                return null;
            }
            return new UpdateSessionSettings((int)options.getMaxLeaseTime().toMinutes());
        }

        private static CreateSessionSettings toGenerated(BeginSessionOptions options) {
            if (options == null) {
                return null;
            }
            return new CreateSessionSettings((int)options.getMaxLeaseTime().toMinutes(), SessionSize.fromString(options.getSize().toString()));
        }
    }
}

