// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.mixedreality.remoterendering.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Information about the output of a successful conversion. Only present when the status of the conversion is
 * 'Succeeded'.
 */
@Immutable
public final class ConversionOutput {
    /*
     * URI of the asset generated by the conversion process.
     */
    @JsonProperty(value = "outputAssetUri", access = JsonProperty.Access.WRITE_ONLY)
    private String outputAssetUri;

    /**
     * Get the outputAssetUri property: URI of the asset generated by the conversion process.
     *
     * @return the outputAssetUri value.
     */
    public String getOutputAssetUri() {
        return this.outputAssetUri;
    }
}
