/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mixedreality.remoterendering;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.mixedreality.remoterendering.RemoteRenderingAsyncClient;
import com.azure.mixedreality.remoterendering.RemoteRenderingClientBuilder;
import com.azure.mixedreality.remoterendering.models.AssetConversion;
import com.azure.mixedreality.remoterendering.models.AssetConversionOptions;
import com.azure.mixedreality.remoterendering.models.BeginSessionOptions;
import com.azure.mixedreality.remoterendering.models.RenderingSession;
import com.azure.mixedreality.remoterendering.models.UpdateSessionOptions;

@ServiceClient(builder=RemoteRenderingClientBuilder.class)
public final class RemoteRenderingClient {
    private final RemoteRenderingAsyncClient client;

    RemoteRenderingClient(RemoteRenderingAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<RenderingSession, RenderingSession> beginSession(String sessionId, BeginSessionOptions options) {
        return this.client.beginSession(sessionId, options).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<RenderingSession, RenderingSession> beginSession(String sessionId) {
        return this.beginSession(sessionId, new BeginSessionOptions());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<RenderingSession, RenderingSession> beginSession(String sessionId, BeginSessionOptions options, Context context) {
        return this.client.beginSessionInternal(sessionId, options, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RenderingSession getSession(String sessionId) {
        return (RenderingSession)this.client.getSession(sessionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RenderingSession> getSessionWithResponse(String sessionId, Context context) {
        return (Response)this.client.getSessionInternal(sessionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RenderingSession updateSession(String sessionId, UpdateSessionOptions options) {
        return (RenderingSession)this.client.updateSession(sessionId, options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RenderingSession> updateSessionWithResponse(String sessionId, UpdateSessionOptions options, Context context) {
        return (Response)this.client.updateSessionInternal(sessionId, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void endSession(String sessionId) {
        this.client.endSession(sessionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> endSessionWithResponse(String sessionId, Context context) {
        return (Response)this.client.endSessionInternal(sessionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RenderingSession> listSessions() {
        return new PagedIterable(this.client.listSessions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RenderingSession> listSessions(Context context) {
        return new PagedIterable(this.client.listSessionsInternal(context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AssetConversion, AssetConversion> beginConversion(String conversionId, AssetConversionOptions options) {
        return this.client.beginConversion(conversionId, options).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AssetConversion, AssetConversion> beginConversion(String conversionId, AssetConversionOptions options, Context context) {
        return this.client.beginConversionInternal(conversionId, options, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AssetConversion getConversion(String conversionId) {
        return (AssetConversion)this.client.getConversion(conversionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AssetConversion> getConversionWithResponse(String conversionId, Context context) {
        return (Response)this.client.getConversionInternal(conversionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AssetConversion> listConversions() {
        return new PagedIterable(this.client.listConversions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AssetConversion> listConversions(Context context) {
        return new PagedIterable(this.client.listConversionsInternal(context));
    }
}

