// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.mixedreality.remoterendering.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Conversion settings describe the origin of input files and destination of output files. */
@Fluent
public final class ConversionSettings {
    /*
     * Conversion input settings describe the origin of conversion input.
     */
    @JsonProperty(value = "inputLocation", required = true)
    private ConversionInputSettings inputLocation;

    /*
     * Conversion output settings describe the destination of conversion
     * output.
     */
    @JsonProperty(value = "outputLocation", required = true)
    private ConversionOutputSettings outputLocation;

    /**
     * Creates an instance of ConversionSettings class.
     *
     * @param inputLocation the inputLocation value to set.
     * @param outputLocation the outputLocation value to set.
     */
    @JsonCreator
    public ConversionSettings(
            @JsonProperty(value = "inputLocation", required = true) ConversionInputSettings inputLocation,
            @JsonProperty(value = "outputLocation", required = true) ConversionOutputSettings outputLocation) {
        this.inputLocation = inputLocation;
        this.outputLocation = outputLocation;
    }

    /**
     * Get the inputLocation property: Conversion input settings describe the origin of conversion input.
     *
     * @return the inputLocation value.
     */
    public ConversionInputSettings getInputLocation() {
        return this.inputLocation;
    }

    /**
     * Get the outputLocation property: Conversion output settings describe the destination of conversion output.
     *
     * @return the outputLocation value.
     */
    public ConversionOutputSettings getOutputLocation() {
        return this.outputLocation;
    }
}
