// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.mixedreality.remoterendering.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.mixedreality.remoterendering.implementation.models.Conversion;
import com.azure.mixedreality.remoterendering.implementation.models.CreateConversionSettings;
import com.azure.mixedreality.remoterendering.implementation.models.CreateSessionSettings;
import com.azure.mixedreality.remoterendering.implementation.models.ErrorResponseException;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsCreateConversionResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsCreateSessionResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsGetConversionResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsListConversionsNextResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsListConversionsResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsStopSessionResponse;
import com.azure.mixedreality.remoterendering.implementation.models.SessionProperties;
import com.azure.mixedreality.remoterendering.implementation.models.SessionsList;
import com.azure.mixedreality.remoterendering.implementation.models.UpdateSessionSettings;
import java.util.UUID;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RemoteRenderings. */
public final class RemoteRenderingsImpl {
    /** The proxy service used to perform REST calls. */
    private final RemoteRenderingsService service;

    /** The service client containing this operation class. */
    private final MixedRealityRemoteRenderingImpl client;

    /**
     * Initializes an instance of RemoteRenderingsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RemoteRenderingsImpl(MixedRealityRemoteRenderingImpl client) {
        this.service =
                RestProxy.create(
                        RemoteRenderingsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MixedRealityRemoteRenderingRemoteRenderings to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "MixedRealityRemoteRe")
    public interface RemoteRenderingsService {
        @Put("/accounts/{account_id}/conversions/{conversion_id}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<RemoteRenderingsCreateConversionResponse> createConversion(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @PathParam("account_id") UUID accountId,
                @PathParam("conversion_id") String conversionId,
                @BodyParam("application/json") CreateConversionSettings body,
                Context context);

        @Get("/accounts/{account_id}/conversions/{conversion_id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<RemoteRenderingsGetConversionResponse> getConversion(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @PathParam("account_id") UUID accountId,
                @PathParam("conversion_id") String conversionId,
                Context context);

        @Get("/accounts/{account_id}/conversions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<RemoteRenderingsListConversionsResponse> listConversions(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @PathParam("account_id") UUID accountId,
                Context context);

        @Put("/accounts/{account_id}/sessions/{session_id}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<RemoteRenderingsCreateSessionResponse> createSession(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @PathParam("account_id") UUID accountId,
                @PathParam("session_id") String sessionId,
                @BodyParam("application/json") CreateSessionSettings body,
                Context context);

        @Get("/accounts/{account_id}/sessions/{session_id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<SessionProperties>> getSession(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @PathParam("account_id") UUID accountId,
                @PathParam("session_id") String sessionId,
                Context context);

        @Patch("/accounts/{account_id}/sessions/{session_id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<SessionProperties>> updateSession(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @PathParam("account_id") UUID accountId,
                @PathParam("session_id") String sessionId,
                @BodyParam("application/json") UpdateSessionSettings body,
                Context context);

        @Post("/accounts/{account_id}/sessions/{session_id}/:stop")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<RemoteRenderingsStopSessionResponse> stopSession(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @PathParam("account_id") UUID accountId,
                @PathParam("session_id") String sessionId,
                Context context);

        @Get("/accounts/{account_id}/sessions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<SessionsList>> listSessions(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @PathParam("account_id") UUID accountId,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<RemoteRenderingsListConversionsNextResponse> listConversionsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<SessionsList>> listSessionsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                Context context);
    }

    /**
     * Creates a conversion using an asset stored in an Azure Blob Storage account.
     *
     * @param accountId The Azure Remote Rendering account ID.
     * @param conversionId An ID uniquely identifying the conversion for the given account. The ID is case sensitive,
     *     can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain
     *     more than 256 characters.
     * @param body Request to start a conversion.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the conversion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RemoteRenderingsCreateConversionResponse> createConversionWithResponseAsync(
            UUID accountId, String conversionId, CreateConversionSettings body, Context context) {
        return service.createConversion(
                this.client.getEndpoint(), this.client.getApiVersion(), accountId, conversionId, body, context);
    }

    /**
     * Gets the status of a particular conversion.
     *
     * @param accountId The Azure Remote Rendering account ID.
     * @param conversionId An ID uniquely identifying the conversion for the given account. The ID is case sensitive,
     *     can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain
     *     more than 256 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of a particular conversion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RemoteRenderingsGetConversionResponse> getConversionWithResponseAsync(
            UUID accountId, String conversionId, Context context) {
        return service.getConversion(
                this.client.getEndpoint(), this.client.getApiVersion(), accountId, conversionId, context);
    }

    /**
     * Gets a list of all conversions.
     *
     * @param accountId The Azure Remote Rendering account ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all conversions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Conversion>> listConversionsSinglePageAsync(UUID accountId, Context context) {
        return service.listConversions(this.client.getEndpoint(), this.client.getApiVersion(), accountId, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getConversions(),
                                        res.getValue().getNextLink(),
                                        res.getDeserializedHeaders()));
    }

    /**
     * Creates a new rendering session.
     *
     * @param accountId The Azure Remote Rendering account ID.
     * @param sessionId An ID uniquely identifying the rendering session for the given account. The ID is case
     *     sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and
     *     cannot contain more than 256 characters.
     * @param body Settings of the session to be created.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a rendering session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RemoteRenderingsCreateSessionResponse> createSessionWithResponseAsync(
            UUID accountId, String sessionId, CreateSessionSettings body, Context context) {
        return service.createSession(
                this.client.getEndpoint(), this.client.getApiVersion(), accountId, sessionId, body, context);
    }

    /**
     * Gets the properties of a particular rendering session.
     *
     * @param accountId The Azure Remote Rendering account ID.
     * @param sessionId An ID uniquely identifying the rendering session for the given account. The ID is case
     *     sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and
     *     cannot contain more than 256 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a particular rendering session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SessionProperties>> getSessionWithResponseAsync(
            UUID accountId, String sessionId, Context context) {
        return service.getSession(
                this.client.getEndpoint(), this.client.getApiVersion(), accountId, sessionId, context);
    }

    /**
     * Updates the max lease time of a particular rendering session.
     *
     * @param accountId The Azure Remote Rendering account ID.
     * @param sessionId An ID uniquely identifying the rendering session for the given account. The ID is case
     *     sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and
     *     cannot contain more than 256 characters.
     * @param body Settings used to update the session.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a rendering session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SessionProperties>> updateSessionWithResponseAsync(
            UUID accountId, String sessionId, UpdateSessionSettings body, Context context) {
        return service.updateSession(
                this.client.getEndpoint(), this.client.getApiVersion(), accountId, sessionId, body, context);
    }

    /**
     * Stops a particular rendering session.
     *
     * @param accountId The Azure Remote Rendering account ID.
     * @param sessionId An ID uniquely identifying the rendering session for the given account. The ID is case
     *     sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and
     *     cannot contain more than 256 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RemoteRenderingsStopSessionResponse> stopSessionWithResponseAsync(
            UUID accountId, String sessionId, Context context) {
        return service.stopSession(
                this.client.getEndpoint(), this.client.getApiVersion(), accountId, sessionId, context);
    }

    /**
     * Gets a list of all rendering sessions.
     *
     * @param accountId The Azure Remote Rendering account ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all rendering sessions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SessionProperties>> listSessionsSinglePageAsync(UUID accountId, Context context) {
        return service.listSessions(this.client.getEndpoint(), this.client.getApiVersion(), accountId, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getSessions(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of conversions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Conversion>> listConversionsNextSinglePageAsync(String nextLink, Context context) {
        return service.listConversionsNext(nextLink, this.client.getEndpoint(), context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getConversions(),
                                        res.getValue().getNextLink(),
                                        res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list sessions request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SessionProperties>> listSessionsNextSinglePageAsync(String nextLink, Context context) {
        return service.listSessionsNext(nextLink, this.client.getEndpoint(), context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getSessions(),
                                        res.getValue().getNextLink(),
                                        null));
    }
}
