// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.mixedreality.remoterendering.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Conversion output settings describe the destination of conversion output. */
@Fluent
public final class ConversionOutputSettings {
    /*
     * The URI of the Azure blob storage container where the result of the
     * conversion should be written to.
     */
    @JsonProperty(value = "storageContainerUri", required = true)
    private String storageContainerUri;

    /*
     * An Azure blob storage container shared access signature giving write
     * access to the storage container. Optional. If not provided, the Azure
     * Remote Rendering account needs to be linked with the storage account
     * containing the blob container. See
     * https://docs.microsoft.com/azure/remote-rendering/how-tos/create-an-account#link-storage-accounts
     * for details. For security purposes this field will never be filled out
     * in responses bodies.
     */
    @JsonProperty(value = "storageContainerWriteSas")
    private String storageContainerWriteSas;

    /*
     * A prefix which gets prepended in front of all files produced by the
     * conversion process. Will be treated as a virtual folder. Optional. If
     * not provided, output files will be stored at the container root.
     */
    @JsonProperty(value = "blobPrefix")
    private String blobPrefix;

    /*
     * The file name of the output asset. Must end in '.arrAsset'. Optional. If
     * not provided, file name will the same name as the input asset, with
     * '.arrAsset' extension
     */
    @JsonProperty(value = "outputAssetFilename")
    private String outputAssetFilename;

    /**
     * Creates an instance of ConversionOutputSettings class.
     *
     * @param storageContainerUri the storageContainerUri value to set.
     */
    @JsonCreator
    public ConversionOutputSettings(
            @JsonProperty(value = "storageContainerUri", required = true) String storageContainerUri) {
        this.storageContainerUri = storageContainerUri;
    }

    /**
     * Get the storageContainerUri property: The URI of the Azure blob storage container where the result of the
     * conversion should be written to.
     *
     * @return the storageContainerUri value.
     */
    public String getStorageContainerUri() {
        return this.storageContainerUri;
    }

    /**
     * Get the storageContainerWriteSas property: An Azure blob storage container shared access signature giving write
     * access to the storage container. Optional. If not provided, the Azure Remote Rendering account needs to be linked
     * with the storage account containing the blob container. See
     * https://docs.microsoft.com/azure/remote-rendering/how-tos/create-an-account#link-storage-accounts for details.
     * For security purposes this field will never be filled out in responses bodies.
     *
     * @return the storageContainerWriteSas value.
     */
    public String getStorageContainerWriteSas() {
        return this.storageContainerWriteSas;
    }

    /**
     * Set the storageContainerWriteSas property: An Azure blob storage container shared access signature giving write
     * access to the storage container. Optional. If not provided, the Azure Remote Rendering account needs to be linked
     * with the storage account containing the blob container. See
     * https://docs.microsoft.com/azure/remote-rendering/how-tos/create-an-account#link-storage-accounts for details.
     * For security purposes this field will never be filled out in responses bodies.
     *
     * @param storageContainerWriteSas the storageContainerWriteSas value to set.
     * @return the ConversionOutputSettings object itself.
     */
    public ConversionOutputSettings setStorageContainerWriteSas(String storageContainerWriteSas) {
        this.storageContainerWriteSas = storageContainerWriteSas;
        return this;
    }

    /**
     * Get the blobPrefix property: A prefix which gets prepended in front of all files produced by the conversion
     * process. Will be treated as a virtual folder. Optional. If not provided, output files will be stored at the
     * container root.
     *
     * @return the blobPrefix value.
     */
    public String getBlobPrefix() {
        return this.blobPrefix;
    }

    /**
     * Set the blobPrefix property: A prefix which gets prepended in front of all files produced by the conversion
     * process. Will be treated as a virtual folder. Optional. If not provided, output files will be stored at the
     * container root.
     *
     * @param blobPrefix the blobPrefix value to set.
     * @return the ConversionOutputSettings object itself.
     */
    public ConversionOutputSettings setBlobPrefix(String blobPrefix) {
        this.blobPrefix = blobPrefix;
        return this;
    }

    /**
     * Get the outputAssetFilename property: The file name of the output asset. Must end in '.arrAsset'. Optional. If
     * not provided, file name will the same name as the input asset, with '.arrAsset' extension.
     *
     * @return the outputAssetFilename value.
     */
    public String getOutputAssetFilename() {
        return this.outputAssetFilename;
    }

    /**
     * Set the outputAssetFilename property: The file name of the output asset. Must end in '.arrAsset'. Optional. If
     * not provided, file name will the same name as the input asset, with '.arrAsset' extension.
     *
     * @param outputAssetFilename the outputAssetFilename value to set.
     * @return the ConversionOutputSettings object itself.
     */
    public ConversionOutputSettings setOutputAssetFilename(String outputAssetFilename) {
        this.outputAssetFilename = outputAssetFilename;
        return this;
    }
}
