// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.mixedreality.remoterendering.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Request to start a conversion. */
@Fluent
public final class CreateConversionSettings {
    /*
     * Conversion settings describe the origin of input files and destination
     * of output files.
     */
    @JsonProperty(value = "settings", required = true)
    private ConversionSettings settings;

    /**
     * Creates an instance of CreateConversionSettings class.
     *
     * @param settings the settings value to set.
     */
    @JsonCreator
    public CreateConversionSettings(@JsonProperty(value = "settings", required = true) ConversionSettings settings) {
        this.settings = settings;
    }

    /**
     * Get the settings property: Conversion settings describe the origin of input files and destination of output
     * files.
     *
     * @return the settings value.
     */
    public ConversionSettings getSettings() {
        return this.settings;
    }
}
