// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.mixedreality.remoterendering.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The properties of a rendering session. */
@Fluent
public final class SessionProperties {
    /*
     * The ID of the session supplied when the session was created.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The TCP port at which the Azure Remote Rendering Inspector tool is
     * hosted.
     */
    @JsonProperty(value = "arrInspectorPort", access = JsonProperty.Access.WRITE_ONLY)
    private Integer arrInspectorPort;

    /*
     * The TCP port used for the handshake when establishing a connection.
     */
    @JsonProperty(value = "handshakePort", access = JsonProperty.Access.WRITE_ONLY)
    private Integer handshakePort;

    /*
     * Amount of time in minutes the session is or was in the 'Ready' state.
     * Time is rounded down to a full minute.
     */
    @JsonProperty(value = "elapsedTimeMinutes", access = JsonProperty.Access.WRITE_ONLY)
    private Integer elapsedTimeMinutes;

    /*
     * The hostname under which the rendering session is reachable.
     */
    @JsonProperty(value = "hostname", access = JsonProperty.Access.WRITE_ONLY)
    private String hostname;

    /*
     * The time in minutes the session will run after reaching the 'Ready'
     * state.
     */
    @JsonProperty(value = "maxLeaseTimeMinutes", access = JsonProperty.Access.WRITE_ONLY)
    private Integer maxLeaseTimeMinutes;

    /*
     * The size of the server used for the rendering session. The size impacts
     * the number of polygons the server can render. Refer to
     * https://docs.microsoft.com/azure/remote-rendering/reference/vm-sizes for
     * details.
     */
    @JsonProperty(value = "size", required = true)
    private SessionSize size;

    /*
     * The status of the rendering session. Terminal states are 'Error',
     * 'Expired', and 'Stopped'.
     */
    @JsonProperty(value = "status", required = true)
    private SessionStatus status;

    /*
     * The computational power of the rendering session GPU measured in
     * teraflops.
     */
    @JsonProperty(value = "teraflops", access = JsonProperty.Access.WRITE_ONLY)
    private Float teraflops;

    /*
     * The error object containing details about the rendering session startup
     * failure.
     */
    @JsonProperty(value = "error", access = JsonProperty.Access.WRITE_ONLY)
    private Error error;

    /*
     * The time when the rendering session was created. Date and time in ISO
     * 8601 format.
     */
    @JsonProperty(value = "creationTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationTime;

    /**
     * Creates an instance of SessionProperties class.
     *
     * @param id the id value to set.
     * @param size the size value to set.
     * @param status the status value to set.
     */
    @JsonCreator
    public SessionProperties(
            @JsonProperty(value = "id", required = true) String id,
            @JsonProperty(value = "size", required = true) SessionSize size,
            @JsonProperty(value = "status", required = true) SessionStatus status) {
        this.id = id;
        this.size = size;
        this.status = status;
    }

    /**
     * Get the id property: The ID of the session supplied when the session was created.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the arrInspectorPort property: The TCP port at which the Azure Remote Rendering Inspector tool is hosted.
     *
     * @return the arrInspectorPort value.
     */
    public Integer getArrInspectorPort() {
        return this.arrInspectorPort;
    }

    /**
     * Get the handshakePort property: The TCP port used for the handshake when establishing a connection.
     *
     * @return the handshakePort value.
     */
    public Integer getHandshakePort() {
        return this.handshakePort;
    }

    /**
     * Get the elapsedTimeMinutes property: Amount of time in minutes the session is or was in the 'Ready' state. Time
     * is rounded down to a full minute.
     *
     * @return the elapsedTimeMinutes value.
     */
    public Integer getElapsedTimeMinutes() {
        return this.elapsedTimeMinutes;
    }

    /**
     * Get the hostname property: The hostname under which the rendering session is reachable.
     *
     * @return the hostname value.
     */
    public String getHostname() {
        return this.hostname;
    }

    /**
     * Get the maxLeaseTimeMinutes property: The time in minutes the session will run after reaching the 'Ready' state.
     *
     * @return the maxLeaseTimeMinutes value.
     */
    public Integer getMaxLeaseTimeMinutes() {
        return this.maxLeaseTimeMinutes;
    }

    /**
     * Get the size property: The size of the server used for the rendering session. The size impacts the number of
     * polygons the server can render. Refer to https://docs.microsoft.com/azure/remote-rendering/reference/vm-sizes for
     * details.
     *
     * @return the size value.
     */
    public SessionSize getSize() {
        return this.size;
    }

    /**
     * Get the status property: The status of the rendering session. Terminal states are 'Error', 'Expired', and
     * 'Stopped'.
     *
     * @return the status value.
     */
    public SessionStatus getStatus() {
        return this.status;
    }

    /**
     * Get the teraflops property: The computational power of the rendering session GPU measured in teraflops.
     *
     * @return the teraflops value.
     */
    public Float getTeraflops() {
        return this.teraflops;
    }

    /**
     * Get the error property: The error object containing details about the rendering session startup failure.
     *
     * @return the error value.
     */
    public Error getError() {
        return this.error;
    }

    /**
     * Get the creationTime property: The time when the rendering session was created. Date and time in ISO 8601 format.
     *
     * @return the creationTime value.
     */
    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }
}
