// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.mixedreality.remoterendering.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for SessionSize. */
public final class SessionSize extends ExpandableStringEnum<SessionSize> {
    /** Static value Standard for SessionSize. */
    public static final SessionSize STANDARD = fromString("Standard");

    /** Static value Premium for SessionSize. */
    public static final SessionSize PREMIUM = fromString("Premium");

    /**
     * Creates or finds a SessionSize from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SessionSize.
     */
    @JsonCreator
    public static SessionSize fromString(String name) {
        return fromString(name, SessionSize.class);
    }

    /** @return known SessionSize values. */
    public static Collection<SessionSize> values() {
        return values(SessionSize.class);
    }
}
