// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.ingestion.implementation;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the asynchronous IngestionUsingDataCollectionRulesClient type.
 */
@ServiceClient(builder = IngestionUsingDataCollectionRulesClientBuilder.class, isAsync = true)
public final class IngestionUsingDataCollectionRulesAsyncClient {
    @Generated
    private final IngestionUsingDataCollectionRulesClientImpl serviceClient;

    /**
     * Initializes an instance of IngestionUsingDataCollectionRulesAsyncClient class.
     * 
     * @param serviceClient the service client implementation.
     */
    @Generated
    IngestionUsingDataCollectionRulesAsyncClient(IngestionUsingDataCollectionRulesClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Ingestion API used to directly ingest data using Data Collection Rules
     * 
     * See error response code and error response message for more detail.
     * <p>
     * <strong>Header Parameters</strong>
     * </p>
     * <table border="1">
     * <caption>Header Parameters</caption>
     * <tr>
     * <th>Name</th>
     * <th>Type</th>
     * <th>Required</th>
     * <th>Description</th>
     * </tr>
     * <tr>
     * <td>Content-Encoding</td>
     * <td>String</td>
     * <td>No</td>
     * <td>gzip</td>
     * </tr>
     * <tr>
     * <td>x-ms-client-request-id</td>
     * <td>String</td>
     * <td>No</td>
     * <td>Client request Id</td>
     * </tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addHeader}
     * <p>
     * <strong>Request Body Schema</strong>
     * </p>
     * <pre>{@code
     * [
     *     Object (Required)
     * ]
     * }</pre>
     * 
     * @param ruleId The immutable Id of the Data Collection Rule resource.
     * @param stream The streamDeclaration name as defined in the Data Collection Rule.
     * @param body An array of objects matching the schema defined by the provided stream.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadWithResponse(String ruleId, String stream, BinaryData body,
        RequestOptions requestOptions) {
        return this.serviceClient.uploadWithResponseAsync(ruleId, stream, body, requestOptions);
    }
}
