// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.monitor.ingestion.implementation;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the asynchronous LogsIngestionClient type.
 */
@ServiceClient(builder = LogsIngestionClientBuilder.class, isAsync = true)
public final class LogsIngestionAsyncClient {

    @Generated
    private final LogsIngestionClientImpl serviceClient;

    /**
     * Initializes an instance of LogsIngestionAsyncClient class.
     *
     * @param serviceClient the service client implementation.
     */
    @Generated
    LogsIngestionAsyncClient(LogsIngestionClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Ingestion API used to directly ingest data using Data Collection Rules.
     * <p><strong>Header Parameters</strong></p>
     * <table border="1">
     * <caption>Header Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>Content-Encoding</td><td>String</td><td>No</td><td>The content encoding of the request body which is
     * always 'gzip'.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addHeader}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * [
     *      (Required){
     *         String: BinaryData (Required)
     *     }
     * ]
     * }
     * </pre>
     *
     * @param ruleId The immutable ID of the Data Collection Rule resource.
     * @param streamName The streamDeclaration name as defined in the Data Collection Rule.
     * @param body The array of objects matching the schema defined by the provided stream.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadWithResponse(String ruleId, String streamName, BinaryData body,
        RequestOptions requestOptions) {
        return this.serviceClient.uploadWithResponseAsync(ruleId, streamName, body, requestOptions);
    }

    /**
     * Ingestion API used to directly ingest data using Data Collection Rules.
     *
     * @param ruleId The immutable ID of the Data Collection Rule resource.
     * @param streamName The streamDeclaration name as defined in the Data Collection Rule.
     * @param body The array of objects matching the schema defined by the provided stream.
     * @param contentEncoding The content encoding of the request body which is always 'gzip'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> upload(String ruleId, String streamName, List<Map<String, BinaryData>> body,
        String contentEncoding) {
        // Generated convenience method for uploadWithResponse
        RequestOptions requestOptions = new RequestOptions();
        if (contentEncoding != null) {
            requestOptions.setHeader(HttpHeaderName.CONTENT_ENCODING, contentEncoding);
        }
        return uploadWithResponse(ruleId, streamName, BinaryData.fromObject(body), requestOptions)
            .flatMap(FluxUtil::toMono);
    }

    /**
     * Ingestion API used to directly ingest data using Data Collection Rules.
     *
     * @param ruleId The immutable ID of the Data Collection Rule resource.
     * @param streamName The streamDeclaration name as defined in the Data Collection Rule.
     * @param body The array of objects matching the schema defined by the provided stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> upload(String ruleId, String streamName, List<Map<String, BinaryData>> body) {
        // Generated convenience method for uploadWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return uploadWithResponse(ruleId, streamName, BinaryData.fromObject(body), requestOptions)
            .flatMap(FluxUtil::toMono);
    }
}
