/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion.implementation;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.monitor.ingestion.implementation.LogsIngestionClientBuilder;
import com.azure.monitor.ingestion.implementation.LogsIngestionClientImpl;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=LogsIngestionClientBuilder.class, isAsync=true)
public final class LogsIngestionAsyncClient {
    private final LogsIngestionClientImpl serviceClient;

    LogsIngestionAsyncClient(LogsIngestionClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadWithResponse(String ruleId, String streamName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.uploadWithResponseAsync(ruleId, streamName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> upload(String ruleId, String streamName, List<Map<String, BinaryData>> body, String contentEncoding) {
        RequestOptions requestOptions = new RequestOptions();
        if (contentEncoding != null) {
            requestOptions.setHeader(HttpHeaderName.CONTENT_ENCODING, contentEncoding);
        }
        return this.uploadWithResponse(ruleId, streamName, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> upload(String ruleId, String streamName, List<Map<String, BinaryData>> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.uploadWithResponse(ruleId, streamName, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }
}

