/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.SharedExecutorService;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.ingestion.LogsIngestionClientBuilder;
import com.azure.monitor.ingestion.implementation.Batcher;
import com.azure.monitor.ingestion.implementation.LogsIngestionClientImpl;
import com.azure.monitor.ingestion.implementation.LogsIngestionRequest;
import com.azure.monitor.ingestion.implementation.UploadLogsResponseHolder;
import com.azure.monitor.ingestion.implementation.Utils;
import com.azure.monitor.ingestion.models.LogsUploadError;
import com.azure.monitor.ingestion.models.LogsUploadException;
import com.azure.monitor.ingestion.models.LogsUploadOptions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ServiceClient(builder=LogsIngestionClientBuilder.class)
public final class LogsIngestionClient
implements AutoCloseable {
    private static final ClientLogger LOGGER = new ClientLogger(LogsIngestionClient.class);
    private final LogsIngestionClientImpl client;

    LogsIngestionClient(LogsIngestionClientImpl client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(String ruleId, String streamName, Iterable<Object> logs) {
        this.upload(ruleId, streamName, logs, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(String ruleId, String streamName, Iterable<Object> logs, LogsUploadOptions options) {
        this.upload(ruleId, streamName, logs, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(String ruleId, String streamName, Iterable<Object> logs, LogsUploadOptions options, Context context) {
        Objects.requireNonNull(ruleId, "'ruleId' cannot be null.");
        Objects.requireNonNull(streamName, "'streamName' cannot be null.");
        Objects.requireNonNull(logs, "'logs' cannot be null.");
        Consumer<LogsUploadError> uploadLogsErrorConsumer = options == null ? null : options.getLogsUploadErrorConsumer();
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.addHeader(HttpHeaderName.CONTENT_ENCODING, "gzip");
        requestOptions.setContext(context);
        Stream<UploadLogsResponseHolder> responses = new Batcher(options, logs).toStream().map(r -> this.uploadToService(ruleId, streamName, requestOptions, (LogsIngestionRequest)r));
        responses = this.submit(responses, Utils.getConcurrency(options)).filter(response -> response.getException() != null);
        if (uploadLogsErrorConsumer != null) {
            responses.forEach(response -> uploadLogsErrorConsumer.accept(new LogsUploadError(response.getException(), response.getRequest().getLogs())));
            return;
        }
        int[] failedLogCount = new int[1];
        List<HttpResponseException> exceptions = responses.map(response -> {
            failedLogCount[0] = failedLogCount[0] + response.getRequest().getLogs().size();
            return response.getException();
        }).collect(Collectors.toList());
        if (!exceptions.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)new LogsUploadException(exceptions, failedLogCount[0])));
        }
    }

    private Stream<UploadLogsResponseHolder> submit(Stream<UploadLogsResponseHolder> responseStream, int concurrency) {
        if (concurrency == 1) {
            return responseStream;
        }
        try {
            return (Stream)SharedExecutorService.getInstance().submit(() -> responseStream).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private UploadLogsResponseHolder uploadToService(String ruleId, String streamName, RequestOptions requestOptions, LogsIngestionRequest request) {
        HttpResponseException exception = null;
        try {
            this.client.uploadWithResponse(ruleId, streamName, BinaryData.fromBytes((byte[])request.getRequestBody()), requestOptions);
        }
        catch (HttpResponseException ex) {
            exception = ex;
        }
        return new UploadLogsResponseHolder(request, exception);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> uploadWithResponse(String ruleId, String streamName, BinaryData logs, RequestOptions requestOptions) {
        Objects.requireNonNull(ruleId, "'ruleId' cannot be null.");
        Objects.requireNonNull(streamName, "'streamName' cannot be null.");
        Objects.requireNonNull(logs, "'logs' cannot be null.");
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addRequestCallback(request -> {
            HttpHeader httpHeader = request.getHeaders().get(HttpHeaderName.CONTENT_ENCODING);
            if (httpHeader == null) {
                BinaryData gzippedRequest = BinaryData.fromBytes((byte[])Utils.gzipRequest(logs.toBytes()));
                request.setBody(gzippedRequest);
                request.setHeader(HttpHeaderName.CONTENT_ENCODING, "gzip");
            }
        });
        return this.client.uploadWithResponse(ruleId, streamName, logs, requestOptions);
    }

    @Override
    public void close() {
    }
}

