/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.monitor.ingestion.LogsIngestionServiceVersion;
import com.azure.monitor.ingestion.implementation.LogsIngestionClientImpl;
import com.azure.monitor.ingestion.models.LogsUploadOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.zip.GZIPOutputStream;

public final class Utils {
    public static final long MAX_REQUEST_PAYLOAD_SIZE = 0x100000L;
    public static final String GZIP = "gzip";
    private static final ClientLogger LOGGER = new ClientLogger(Utils.class);

    private Utils() {
    }

    public static byte[] gzipRequest(byte[] bytes) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream zip = new GZIPOutputStream(byteArrayOutputStream);){
            zip.write(bytes);
        }
        catch (IOException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(exception));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int getConcurrency(LogsUploadOptions options) {
        if (options != null && options.getMaxConcurrency() != null) {
            return options.getMaxConcurrency();
        }
        return 1;
    }

    public static LogsIngestionClientImpl getLogsIngestionClientImpl(HttpPipeline httpPipeline, String endpoint, LogsIngestionServiceVersion serviceVersion) {
        return new LogsIngestionClientImpl(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }
}

