/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.ingestion.LogsIngestionAsyncClient;
import com.azure.monitor.ingestion.LogsIngestionClient;
import com.azure.monitor.ingestion.LogsIngestionServiceVersion;
import com.azure.monitor.ingestion.implementation.IngestionUsingDataCollectionRulesClientBuilder;
import com.azure.monitor.ingestion.implementation.IngestionUsingDataCollectionRulesServiceVersion;
import com.azure.monitor.ingestion.models.LogsIngestionAudience;
import java.net.MalformedURLException;
import java.net.URL;

@ServiceClientBuilder(serviceClients={LogsIngestionClient.class, LogsIngestionAsyncClient.class})
public final class LogsIngestionClientBuilder
implements ConfigurationTrait<LogsIngestionClientBuilder>,
HttpTrait<LogsIngestionClientBuilder>,
EndpointTrait<LogsIngestionClientBuilder>,
TokenCredentialTrait<LogsIngestionClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(LogsIngestionClientBuilder.class);
    private final IngestionUsingDataCollectionRulesClientBuilder innerLogBuilder = new IngestionUsingDataCollectionRulesClientBuilder();
    private String endpoint;
    private TokenCredential tokenCredential;

    public LogsIngestionClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
            this.innerLogBuilder.endpoint(endpoint);
            this.endpoint = endpoint;
            return this;
        }
        catch (MalformedURLException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL.", exception));
        }
    }

    public LogsIngestionClientBuilder pipeline(HttpPipeline pipeline) {
        this.innerLogBuilder.pipeline(pipeline);
        return this;
    }

    public LogsIngestionClientBuilder httpClient(HttpClient httpClient) {
        this.innerLogBuilder.httpClient(httpClient);
        return this;
    }

    public LogsIngestionClientBuilder configuration(Configuration configuration) {
        this.innerLogBuilder.configuration(configuration);
        return this;
    }

    public LogsIngestionClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.innerLogBuilder.httpLogOptions(httpLogOptions);
        return this;
    }

    public LogsIngestionClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.innerLogBuilder.retryPolicy(retryPolicy);
        return this;
    }

    public LogsIngestionClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.innerLogBuilder.addPolicy(customPolicy);
        return this;
    }

    public LogsIngestionClientBuilder retryOptions(RetryOptions retryOptions) {
        this.innerLogBuilder.retryOptions(retryOptions);
        return this;
    }

    public LogsIngestionClientBuilder credential(TokenCredential tokenCredential) {
        this.innerLogBuilder.credential(tokenCredential);
        this.tokenCredential = tokenCredential;
        return this;
    }

    public LogsIngestionClientBuilder audience(LogsIngestionAudience audience) {
        this.innerLogBuilder.audience(audience);
        return this;
    }

    public LogsIngestionClientBuilder clientOptions(ClientOptions clientOptions) {
        this.innerLogBuilder.clientOptions(clientOptions);
        return this;
    }

    public LogsIngestionClientBuilder serviceVersion(LogsIngestionServiceVersion serviceVersion) {
        this.innerLogBuilder.serviceVersion(IngestionUsingDataCollectionRulesServiceVersion.valueOf(serviceVersion.getVersion()));
        return this;
    }

    public LogsIngestionClient buildClient() {
        if (this.endpoint == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("endpoint is required to build the client."));
        }
        if (this.tokenCredential == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("credential is required to build the client."));
        }
        return new LogsIngestionClient(this.innerLogBuilder.buildClient());
    }

    public LogsIngestionAsyncClient buildAsyncClient() {
        if (this.endpoint == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("endpoint is required to build the client."));
        }
        if (this.tokenCredential == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("credential is required to build the client."));
        }
        return new LogsIngestionAsyncClient(this.innerLogBuilder.buildAsyncClient());
    }
}

