/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.monitor.ingestion.implementation.ConcurrencyLimitingSpliterator;
import com.azure.monitor.ingestion.implementation.LogsIngestionRequest;
import com.azure.monitor.ingestion.implementation.Utils;
import com.azure.monitor.ingestion.models.LogsUploadOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import reactor.core.publisher.Flux;

public class Batcher
implements Iterator<LogsIngestionRequest> {
    private static final ClientLogger LOGGER = new ClientLogger(Batcher.class);
    private static final JsonSerializer DEFAULT_SERIALIZER = JsonSerializerProviders.createInstance((boolean)true);
    private final ObjectSerializer serializer;
    private final int concurrency;
    private final Iterator<Object> iterator;
    private long currentBatchSize;
    private List<String> serializedLogs;
    private List<Object> originalLogsRequest;

    public Batcher(LogsUploadOptions options, Iterable<Object> logs) {
        this.serializer = Batcher.getSerializer(options);
        this.concurrency = Utils.getConcurrency(options);
        this.serializedLogs = new ArrayList<String>();
        this.originalLogsRequest = new ArrayList<Object>();
        this.iterator = logs.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext() || this.currentBatchSize > 0L;
    }

    @Override
    public LogsIngestionRequest next() {
        try {
            return this.nextInternal();
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public Stream<LogsIngestionRequest> toStream() {
        if (this.concurrency == 1) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 272), false);
        }
        return StreamSupport.stream(new ConcurrencyLimitingSpliterator<LogsIngestionRequest>(this, this.concurrency), true);
    }

    public Flux<LogsIngestionRequest> toFlux() {
        return Flux.create(emitter -> {
            try {
                while (this.hasNext()) {
                    LogsIngestionRequest next = this.nextInternal();
                    if (next == null) continue;
                    emitter.next((Object)next);
                }
            }
            catch (IOException ex) {
                emitter.error((Throwable)ex);
            }
            emitter.complete();
        });
    }

    private LogsIngestionRequest nextInternal() throws IOException {
        LogsIngestionRequest result = null;
        while (this.iterator.hasNext() && result == null) {
            Object currentLog = this.iterator.next();
            byte[] bytes = this.serializer.serializeToBytes(currentLog);
            this.currentBatchSize += (long)bytes.length;
            if (this.currentBatchSize > 0x100000L) {
                result = this.createRequest(false);
                this.currentBatchSize = bytes.length;
            }
            this.serializedLogs.add(new String(bytes, StandardCharsets.UTF_8));
            this.originalLogsRequest.add(currentLog);
        }
        if (result == null && this.currentBatchSize > 0L) {
            this.currentBatchSize = 0L;
            return this.createRequest(true);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private LogsIngestionRequest createRequest(boolean last) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ObjectSerializer getSerializer(LogsUploadOptions options) {
        if (options != null && options.getObjectSerializer() != null) {
            return options.getObjectSerializer();
        }
        return DEFAULT_SERIALIZER;
    }
}

