/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion.implementation;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

class ConcurrencyLimitingSpliterator<T>
implements Spliterator<T> {
    private final AtomicInteger concurrency;
    private final Iterator<T> iterator;

    ConcurrencyLimitingSpliterator(Iterator<T> iterator, int concurrency) {
        Objects.requireNonNull(iterator, "'iterator' cannot be null");
        if (concurrency == 0) {
            throw new IllegalArgumentException("'concurrency' must be a positive number.");
        }
        this.concurrency = new AtomicInteger(concurrency);
        this.iterator = iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Object request = null;
        Iterator<T> iterator = this.iterator;
        synchronized (iterator) {
            if (this.iterator.hasNext()) {
                request = this.iterator.next();
            }
        }
        if (request != null) {
            action.accept(request);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        return this.concurrency.getAndDecrement() > 1 ? new ConcurrencyLimitingSpliterator<T>(this.iterator, 1) : null;
    }

    @Override
    public long estimateSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 272;
    }
}

