/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.ingestion.models.LogsUploadOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

public final class Utils {
    public static final long MAX_REQUEST_PAYLOAD_SIZE = 0x100000L;
    public static final String GZIP = "gzip";
    private static final ClientLogger LOGGER = new ClientLogger(Utils.class);
    private static final int MAX_CONCURRENCY = 10 * Runtime.getRuntime().availableProcessors();

    private Utils() {
    }

    public static byte[] gzipRequest(byte[] bytes) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream zip = new GZIPOutputStream(byteArrayOutputStream);){
            zip.write(bytes);
        }
        catch (IOException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(exception));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int getConcurrency(LogsUploadOptions options) {
        if (options != null && options.getMaxConcurrency() != null) {
            return options.getMaxConcurrency();
        }
        return 1;
    }

    public static ExecutorService createThreadPool() {
        return new ThreadPoolExecutor(0, MAX_CONCURRENCY, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static Thread registerShutdownHook(ExecutorService threadPool, int timeoutSec) {
        long halfTimeoutNanos = TimeUnit.SECONDS.toNanos(timeoutSec) / 2L;
        Thread hook = new Thread(() -> {
            try {
                threadPool.shutdown();
                if (!threadPool.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS)) {
                    threadPool.shutdownNow();
                    threadPool.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                threadPool.shutdownNow();
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        return hook;
    }
}

