/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.ingestion.implementation.IngestionUsingDataCollectionRulesServiceVersion;
import reactor.core.publisher.Mono;

public final class IngestionUsingDataCollectionRulesClientImpl {
    private final IngestionUsingDataCollectionRulesClientService service;
    private final String endpoint;
    private final IngestionUsingDataCollectionRulesServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private static final ClientLogger LOGGER = new ClientLogger(IngestionUsingDataCollectionRulesClientImpl.class);

    public String getEndpoint() {
        return this.endpoint;
    }

    public IngestionUsingDataCollectionRulesServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    IngestionUsingDataCollectionRulesClientImpl(String endpoint, IngestionUsingDataCollectionRulesServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    IngestionUsingDataCollectionRulesClientImpl(HttpPipeline httpPipeline, String endpoint, IngestionUsingDataCollectionRulesServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    IngestionUsingDataCollectionRulesClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, IngestionUsingDataCollectionRulesServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (IngestionUsingDataCollectionRulesClientService)RestProxy.create(IngestionUsingDataCollectionRulesClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadWithResponseAsync(String ruleId, String stream, BinaryData body, RequestOptions requestOptions) {
        if (ruleId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (stream == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Parameter stream is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.upload(this.getEndpoint(), ruleId, stream, this.getServiceVersion().getVersion(), body, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> uploadWithResponse(String ruleId, String stream, BinaryData body, RequestOptions requestOptions) {
        if (ruleId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (stream == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Parameter stream is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.uploadSync(this.getEndpoint(), ruleId, stream, this.getServiceVersion().getVersion(), body, "application/json", requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="IngestionUsingDataCo")
    public static interface IngestionUsingDataCollectionRulesClientService {
        @Post(value="/dataCollectionRules/{ruleId}/streams/{stream}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> upload(@HostParam(value="endpoint") String var1, @PathParam(value="ruleId") String var2, @PathParam(value="stream") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") BinaryData var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/dataCollectionRules/{ruleId}/streams/{stream}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> uploadSync(@HostParam(value="endpoint") String var1, @PathParam(value="ruleId") String var2, @PathParam(value="stream") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") BinaryData var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);
    }
}

