/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure;

import com.azure.monitor.opentelemetry.autoconfigure.AzureMonitorAutoConfigureOptions;
import com.azure.monitor.opentelemetry.autoconfigure.AzureMonitorExporterBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.AzureMonitorLogRecordExporterProvider;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.AzureMonitorMetricExporterProvider;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.AzureMonitorSpanExporterProvider;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.View;
import java.util.HashMap;

public final class AzureMonitorAutoConfigure {
    private AzureMonitorAutoConfigure() {
    }

    public static void customize(AutoConfigurationCustomizer autoConfigurationCustomizer) {
        AzureMonitorAutoConfigureOptions exporterOptions = new AzureMonitorAutoConfigureOptions();
        AzureMonitorAutoConfigure.customize(autoConfigurationCustomizer, exporterOptions);
    }

    public static void customize(AutoConfigurationCustomizer autoConfigurationCustomizer, String connectionString) {
        AzureMonitorAutoConfigureOptions exporterOptions = new AzureMonitorAutoConfigureOptions().connectionString(connectionString);
        AzureMonitorAutoConfigure.customize(autoConfigurationCustomizer, exporterOptions);
    }

    public static void customize(AutoConfigurationCustomizer autoConfigurationCustomizer, AzureMonitorAutoConfigureOptions exporterOptions) {
        autoConfigurationCustomizer.addPropertiesSupplier(() -> {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("otel.traces.exporter", "azure_monitor");
            props.put("otel.metrics.exporter", "azure_monitor");
            props.put("otel.logs.exporter", "azure_monitor");
            props.put("_internal_using_azure_monitor_exporter_builder", "true");
            return props;
        });
        AzureMonitorExporterBuilder azureMonitorExporterBuilder = new AzureMonitorExporterBuilder();
        autoConfigurationCustomizer.addSpanExporterCustomizer((spanExporter, configProperties) -> {
            if (spanExporter instanceof AzureMonitorSpanExporterProvider.MarkerSpanExporter) {
                azureMonitorExporterBuilder.initializeIfNot(exporterOptions, (ConfigProperties)configProperties);
                spanExporter = azureMonitorExporterBuilder.buildSpanExporter();
            }
            return spanExporter;
        });
        autoConfigurationCustomizer.addMetricExporterCustomizer((metricExporter, configProperties) -> {
            if (metricExporter instanceof AzureMonitorMetricExporterProvider.MarkerMetricExporter) {
                azureMonitorExporterBuilder.initializeIfNot(exporterOptions, (ConfigProperties)configProperties);
                metricExporter = azureMonitorExporterBuilder.buildMetricExporter();
            }
            return metricExporter;
        });
        autoConfigurationCustomizer.addLogRecordExporterCustomizer((logRecordExporter, configProperties) -> {
            if (logRecordExporter instanceof AzureMonitorLogRecordExporterProvider.MarkerLogRecordExporter) {
                azureMonitorExporterBuilder.initializeIfNot(exporterOptions, (ConfigProperties)configProperties);
                logRecordExporter = azureMonitorExporterBuilder.buildLogRecordExporter();
            }
            return logRecordExporter;
        });
        autoConfigurationCustomizer.addMeterProviderCustomizer((sdkMeterProviderBuilder, config) -> sdkMeterProviderBuilder.registerView(InstrumentSelector.builder().setMeterName("io.opentelemetry.sdk.trace").build(), View.builder().setAggregation(Aggregation.drop()).build()).registerView(InstrumentSelector.builder().setMeterName("io.opentelemetry.sdk.logs").build(), View.builder().setAggregation(Aggregation.drop()).build()));
    }
}

