/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.monitor.opentelemetry.autoconfigure.AzureMonitorAutoConfigureOptions;
import com.azure.monitor.opentelemetry.autoconfigure.AzureMonitorLogRecordExporter;
import com.azure.monitor.opentelemetry.autoconfigure.AzureMonitorMetricExporter;
import com.azure.monitor.opentelemetry.autoconfigure.AzureMonitorTraceExporter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.LogDataMapper;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.MetricDataMapper;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.NoopTracer;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.SpanDataMapper;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.StatsbeatConnectionString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.heartbeat.HeartbeatExporter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.localstorage.LocalStorageStats;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.Feature;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.StatsbeatModule;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.AzureMonitorHelper;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.PropertyHelper;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.ResourceParser;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.TempDirs;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.VersionGenerator;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

class AzureMonitorExporterBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorExporterBuilder.class);
    private static final String APPLICATIONINSIGHTS_AUTHENTICATION_SCOPE = "https://monitor.azure.com//.default";
    private static final String STATSBEAT_LONG_INTERVAL_SECONDS_PROPERTY_NAME = "STATSBEAT_LONG_INTERVAL_SECONDS_PROPERTY_NAME";
    private static final String STATSBEAT_SHORT_INTERVAL_SECONDS_PROPERTY_NAME = "STATSBEAT_SHORT_INTERVAL_SECONDS_PROPERTY_NAME";
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-monitor-opentelemetry-exporter.properties");
    private AzureMonitorAutoConfigureOptions exporterOptions;
    private TelemetryItemExporter builtTelemetryItemExporter;
    private StatsbeatModule statsbeatModule;
    private ConfigProperties configProperties;
    private boolean initialized;

    AzureMonitorExporterBuilder() {
    }

    void initializeIfNot(AzureMonitorAutoConfigureOptions exporterOptions, ConfigProperties configProperties) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.exporterOptions = exporterOptions;
        this.configProperties = configProperties;
        HttpPipeline httpPipeline = this.createHttpPipeline();
        this.statsbeatModule = this.initStatsbeatModule(configProperties);
        File tempDir = TempDirs.getApplicationInsightsTempDir(LOGGER, "Telemetry will not be stored to disk and retried on sporadic network failures");
        this.builtTelemetryItemExporter = AzureMonitorHelper.createTelemetryItemExporter(httpPipeline, this.statsbeatModule, tempDir, LocalStorageStats.noop());
        this.startStatsbeatModule(this.statsbeatModule, configProperties, tempDir);
    }

    SpanExporter buildSpanExporter() {
        return new AzureMonitorTraceExporter(this.createSpanDataMapper(), this.builtTelemetryItemExporter, this.statsbeatModule);
    }

    LogRecordExporter buildLogRecordExporter() {
        return new AzureMonitorLogRecordExporter(new LogDataMapper(true, false, this.createDefaultsPopulator()), this.builtTelemetryItemExporter);
    }

    MetricExporter buildMetricExporter() {
        HeartbeatExporter.start(TimeUnit.MINUTES.toSeconds(15L), this.createDefaultsPopulator(), this.builtTelemetryItemExporter::send);
        return new AzureMonitorMetricExporter(new MetricDataMapper(this.createDefaultsPopulator(), true), this.builtTelemetryItemExporter);
    }

    private Set<Feature> initStatsbeatFeatures() {
        if (System.getProperty("org.graalvm.nativeimage.imagecode") != null) {
            return Collections.singleton(Feature.GRAAL_VM_NATIVE);
        }
        return Collections.emptySet();
    }

    private StatsbeatConnectionString getStatsbeatConnectionString() {
        return StatsbeatConnectionString.create(this.exporterOptions.connectionString, null, null);
    }

    private SpanDataMapper createSpanDataMapper() {
        return new SpanDataMapper(true, this.createDefaultsPopulator(), (event, instrumentationName) -> false, (span, event) -> false);
    }

    private BiConsumer<AbstractTelemetryBuilder, Resource> createDefaultsPopulator() {
        ConnectionString connectionString = this.getConnectionString();
        ResourceParser resourceParser = new ResourceParser();
        return (builder, resource) -> {
            builder.setConnectionString(connectionString);
            builder.setResource((Resource)resource);
            builder.addTag(ContextTagKeys.AI_INTERNAL_SDK_VERSION.toString(), VersionGenerator.getSdkVersion());
            resourceParser.updateRoleNameAndInstance((AbstractTelemetryBuilder)builder, (Resource)resource);
        };
    }

    private ConnectionString getConnectionString() {
        if (this.exporterOptions.connectionString != null) {
            return this.exporterOptions.connectionString;
        }
        ConnectionString connectionString = ConnectionString.parse(this.configProperties.getString("applicationinsights.connection.string"));
        return connectionString;
    }

    private HttpPipeline createHttpPipeline() {
        if (this.exporterOptions.httpPipeline != null) {
            if (this.exporterOptions.credential != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'credential' is not supported when custom 'httpPipeline' is specified"));
            }
            if (this.exporterOptions.httpClient != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'httpClient' is not supported when custom 'httpPipeline' is specified"));
            }
            if (this.exporterOptions.httpLogOptions != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'httpLogOptions' is not supported when custom 'httpPipeline' is specified"));
            }
            if (!this.exporterOptions.httpPipelinePolicies.isEmpty()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'httpPipelinePolicies' is not supported when custom 'httpPipeline' is specified"));
            }
            if (this.exporterOptions.clientOptions != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'clientOptions' is not supported when custom 'httpPipeline' is specified"));
            }
            if (this.exporterOptions.retryOptions != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'retryOptions' is not supported when custom 'httpPipeline' is specified"));
            }
            return this.exporterOptions.httpPipeline;
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault("name", "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault("version", "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.exporterOptions.clientOptions, (HttpLogOptions)this.exporterOptions.httpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, Configuration.getGlobalConfiguration()));
        policies.add(new CookiePolicy());
        if (this.exporterOptions.credential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.exporterOptions.credential, new String[]{APPLICATIONINSIGHTS_AUTHENTICATION_SCOPE}));
        }
        if (this.exporterOptions.retryOptions != null) {
            policies.add(new RetryPolicy(this.exporterOptions.retryOptions));
        }
        policies.addAll(this.exporterOptions.httpPipelinePolicies);
        policies.add(new HttpLoggingPolicy(this.exporterOptions.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.exporterOptions.httpClient).tracer((Tracer)new NoopTracer()).build();
    }

    private StatsbeatModule initStatsbeatModule(ConfigProperties configProperties) {
        return new StatsbeatModule(PropertyHelper::lazyUpdateVmRpIntegration);
    }

    private void startStatsbeatModule(StatsbeatModule statsbeatModule, ConfigProperties configProperties, File tempDir) {
        HttpPipeline statsbeatHttpPipeline = this.createStatsbeatHttpPipeline();
        TelemetryItemExporter statsbeatTelemetryItemExporter = AzureMonitorHelper.createStatsbeatTelemetryItemExporter(statsbeatHttpPipeline, statsbeatModule, tempDir);
        statsbeatModule.start(statsbeatTelemetryItemExporter, this::getStatsbeatConnectionString, this.getConnectionString()::getInstrumentationKey, false, configProperties.getLong(STATSBEAT_SHORT_INTERVAL_SECONDS_PROPERTY_NAME, TimeUnit.MINUTES.toSeconds(15L)), configProperties.getLong(STATSBEAT_LONG_INTERVAL_SECONDS_PROPERTY_NAME, TimeUnit.DAYS.toSeconds(1L)), false, this.initStatsbeatFeatures());
    }

    private HttpPipeline createStatsbeatHttpPipeline() {
        if (this.exporterOptions.httpPipeline != null) {
            return this.exporterOptions.httpPipeline;
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault("name", "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault("version", "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.exporterOptions.clientOptions, (HttpLogOptions)this.exporterOptions.httpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, Configuration.getGlobalConfiguration()));
        policies.add(new CookiePolicy());
        policies.addAll(this.exporterOptions.httpPipelinePolicies);
        policies.add(new HttpLoggingPolicy(this.exporterOptions.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.exporterOptions.httpClient).tracer((Tracer)new NoopTracer()).build();
    }
}

