/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.LogDataMapper;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.SemanticAttributes;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.AzureMonitorMsgId;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

class AzureMonitorLogRecordExporter
implements LogRecordExporter {
    private static final String EXPORTER_LOGGER_PREFIX = "com.azure.monitor.opentelemetry.exporter";
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorLogRecordExporter.class);
    private static final OperationLogger OPERATION_LOGGER = new OperationLogger(AzureMonitorLogRecordExporter.class, "Exporting log");
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final LogDataMapper mapper;
    private final TelemetryItemExporter telemetryItemExporter;

    AzureMonitorLogRecordExporter(LogDataMapper mapper, TelemetryItemExporter telemetryItemExporter) {
        this.mapper = mapper;
        this.telemetryItemExporter = telemetryItemExporter;
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.stopped.get()) {
            return CompletableResultCode.ofFailure();
        }
        ArrayList<TelemetryItem> telemetryItems = new ArrayList<TelemetryItem>();
        for (LogRecordData log : logs) {
            if (log.getInstrumentationScopeInfo().getName().startsWith(EXPORTER_LOGGER_PREFIX)) continue;
            LOGGER.verbose("exporting log: {}", new Object[]{log});
            try {
                String stack = (String)log.getAttributes().get(SemanticAttributes.EXCEPTION_STACKTRACE);
                telemetryItems.add(this.mapper.map(log, stack, null));
                OPERATION_LOGGER.recordSuccess();
            }
            catch (Throwable t) {
                OPERATION_LOGGER.recordFailure(t.getMessage(), t, AzureMonitorMsgId.EXPORTER_MAPPING_ERROR);
                return CompletableResultCode.ofFailure();
            }
        }
        return this.telemetryItemExporter.send(telemetryItems);
    }

    public CompletableResultCode flush() {
        return this.telemetryItemExporter.flush();
    }

    public CompletableResultCode shutdown() {
        this.stopped.set(true);
        return this.telemetryItemExporter.shutdown();
    }
}

