/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.ExportResult;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.ExportResultException;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryItem;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ApplicationInsightsClientImpl {
    private final ApplicationInsightsClientService service;
    private final String host;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getHost() {
        return this.host;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    ApplicationInsightsClientImpl(String host) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), host);
    }

    ApplicationInsightsClientImpl(HttpPipeline httpPipeline, String host) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), host);
    }

    ApplicationInsightsClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String host) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.host = host;
        this.service = (ApplicationInsightsClientService)RestProxy.create(ApplicationInsightsClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExportResult>> trackWithResponseAsync(List<TelemetryItem> body) {
        return FluxUtil.withContext(context -> this.trackWithResponseAsync(body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExportResult>> trackWithResponseAsync(List<TelemetryItem> body, Context context) {
        String accept = "application/json";
        return this.service.track(this.getHost(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExportResult> trackAsync(List<TelemetryItem> body) {
        return this.trackWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty((Object)((ExportResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExportResult> trackAsync(List<TelemetryItem> body, Context context) {
        return this.trackWithResponseAsync(body, context).flatMap(res -> Mono.justOrEmpty((Object)((ExportResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExportResult> trackWithResponse(List<TelemetryItem> body, Context context) {
        String accept = "application/json";
        return this.service.trackSync(this.getHost(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExportResult track(List<TelemetryItem> body) {
        return (ExportResult)this.trackWithResponse(body, Context.NONE).getValue();
    }

    @Host(value="{Host}/v2.1")
    @ServiceInterface(name="ApplicationInsightsC")
    public static interface ApplicationInsightsClientService {
        @Post(value="/track")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ExportResultException.class, code={400, 402, 500, 429, 503}), @UnexpectedResponseExceptionType(value=ExportResultException.class)})
        public Mono<Response<ExportResult>> track(@HostParam(value="Host") String var1, @BodyParam(value="application/json") List<TelemetryItem> var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/track")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ExportResultException.class, code={400, 402, 500, 429, 503}), @UnexpectedResponseExceptionType(value=ExportResultException.class)})
        public Response<ExportResult> trackSync(@HostParam(value="Host") String var1, @BodyParam(value="application/json") List<TelemetryItem> var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

