/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.AiSemanticAttributes;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.Mappings;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.MappingsBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.SemanticAttributes;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.SpanDataMapper;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.ExceptionTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.MessageTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.SeverityLevel;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.FormattedTime;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.function.BiConsumer;
import reactor.util.annotation.Nullable;

public class LogDataMapper {
    private static final ClientLogger logger = new ClientLogger(LogDataMapper.class);
    private static final String LOG4J_MDC_PREFIX = "log4j.mdc.";
    private static final String LOG4J_CONTEXT_DATA_PREFIX = "log4j.context_data.";
    private static final String LOGBACK_MDC_PREFIX = "logback.mdc.";
    private static final String JBOSS_LOGGING_MDC_PREFIX = "jboss-logmanager.mdc.";
    private static final String LOG4J_MAP_MESSAGE_PREFIX = "log4j.map_message.";
    private static final AttributeKey<String> LOG4J_MARKER = AttributeKey.stringKey((String)"log4j.marker");
    private static final AttributeKey<List<String>> LOGBACK_MARKER = AttributeKey.stringArrayKey((String)"logback.marker");
    private static final Mappings MAPPINGS;
    private final boolean captureLoggingLevelAsCustomDimension;
    private final boolean captureAzureFunctionsAttributes;
    private final BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer;

    public LogDataMapper(boolean captureLoggingLevelAsCustomDimension, boolean captureAzureFunctionsAttributes, BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer) {
        this.captureLoggingLevelAsCustomDimension = captureLoggingLevelAsCustomDimension;
        this.captureAzureFunctionsAttributes = captureAzureFunctionsAttributes;
        this.telemetryInitializer = telemetryInitializer;
    }

    public TelemetryItem map(LogRecordData log, @Nullable String stack, @Nullable Double sampleRate) {
        if (sampleRate == null) {
            sampleRate = LogDataMapper.getSampleRate(log);
        }
        if (stack == null) {
            return this.createMessageTelemetryItem(log, sampleRate);
        }
        return this.createExceptionTelemetryItem(log, stack, sampleRate);
    }

    private TelemetryItem createMessageTelemetryItem(LogRecordData log, @Nullable Double sampleRate) {
        MessageTelemetryBuilder telemetryBuilder = MessageTelemetryBuilder.create();
        this.telemetryInitializer.accept(telemetryBuilder, log.getResource());
        LogDataMapper.setOperationTags(telemetryBuilder, log);
        LogDataMapper.setTime(telemetryBuilder, log);
        LogDataMapper.setSampleRate(telemetryBuilder, sampleRate);
        Attributes attributes = log.getAttributes();
        if (this.captureAzureFunctionsAttributes) {
            LogDataMapper.setFunctionExtraTraceAttributes(telemetryBuilder, attributes);
        }
        MAPPINGS.map(attributes, telemetryBuilder);
        telemetryBuilder.setSeverityLevel(LogDataMapper.toSeverityLevel(log.getSeverity()));
        telemetryBuilder.setMessage(log.getBody().asString());
        this.setLoggerProperties(telemetryBuilder, log.getInstrumentationScopeInfo().getName(), (String)attributes.get(SemanticAttributes.THREAD_NAME), log.getSeverity());
        return telemetryBuilder.build();
    }

    private TelemetryItem createExceptionTelemetryItem(LogRecordData log, String stack, @Nullable Double sampleRate) {
        ExceptionTelemetryBuilder telemetryBuilder = ExceptionTelemetryBuilder.create();
        this.telemetryInitializer.accept(telemetryBuilder, log.getResource());
        LogDataMapper.setOperationTags(telemetryBuilder, log);
        LogDataMapper.setTime(telemetryBuilder, log);
        LogDataMapper.setSampleRate(telemetryBuilder, sampleRate);
        Attributes attributes = log.getAttributes();
        MAPPINGS.map(attributes, telemetryBuilder);
        SpanDataMapper.setExceptions(stack, log.getAttributes(), telemetryBuilder);
        telemetryBuilder.setSeverityLevel(LogDataMapper.toSeverityLevel(log.getSeverity()));
        this.setLoggerProperties(telemetryBuilder, log.getInstrumentationScopeInfo().getName(), (String)attributes.get(SemanticAttributes.THREAD_NAME), log.getSeverity());
        if (log.getBody() != null) {
            telemetryBuilder.addProperty("Logger Message", log.getBody().asString());
        }
        return telemetryBuilder.build();
    }

    private static void setOperationTags(AbstractTelemetryBuilder telemetryBuilder, LogRecordData log) {
        SpanContext spanContext = log.getSpanContext();
        if (spanContext.isValid()) {
            telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_ID.toString(), spanContext.getTraceId());
            telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_PARENT_ID.toString(), spanContext.getSpanId());
        }
        LogDataMapper.setOperationName(telemetryBuilder, log.getAttributes());
    }

    private static void setOperationName(AbstractTelemetryBuilder telemetryBuilder, Attributes attributes) {
        String operationName = (String)attributes.get(AiSemanticAttributes.OPERATION_NAME);
        if (operationName != null) {
            telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_NAME.toString(), operationName);
        }
    }

    private static void setTime(AbstractTelemetryBuilder telemetryBuilder, LogRecordData log) {
        telemetryBuilder.setTime(FormattedTime.offSetDateTimeFromEpochNanos(LogDataMapper.getTimestampEpochNanosWithFallback(log)));
    }

    private static long getTimestampEpochNanosWithFallback(LogRecordData log) {
        long timestamp = log.getTimestampEpochNanos();
        if (timestamp != 0L) {
            return timestamp;
        }
        return log.getObservedTimestampEpochNanos();
    }

    private static void setSampleRate(AbstractTelemetryBuilder telemetryBuilder, @Nullable Double sampleRate) {
        if (sampleRate != null) {
            telemetryBuilder.setSampleRate(sampleRate.floatValue());
        }
    }

    @Nullable
    private static Double getSampleRate(LogRecordData log) {
        return (Double)log.getAttributes().get(AiSemanticAttributes.SAMPLE_RATE);
    }

    private static void setFunctionExtraTraceAttributes(AbstractTelemetryBuilder telemetryBuilder, Attributes attributes) {
        String liveLogsSessionId;
        String hostInstanceId;
        String category;
        String logLevel;
        String processId;
        String invocationId = (String)attributes.get(AiSemanticAttributes.AZ_FN_INVOCATION_ID);
        if (invocationId != null) {
            telemetryBuilder.addProperty("InvocationId", invocationId);
        }
        if ((processId = (String)attributes.get(AiSemanticAttributes.AZ_FN_PROCESS_ID)) != null) {
            telemetryBuilder.addProperty("ProcessId", processId);
        }
        if ((logLevel = (String)attributes.get(AiSemanticAttributes.AZ_FN_LOG_LEVEL)) != null) {
            telemetryBuilder.addProperty("LogLevel", logLevel);
        }
        if ((category = (String)attributes.get(AiSemanticAttributes.AZ_FN_CATEGORY)) != null) {
            telemetryBuilder.addProperty("Category", category);
        }
        if ((hostInstanceId = (String)attributes.get(AiSemanticAttributes.AZ_FN_HOST_INSTANCE_ID)) != null) {
            telemetryBuilder.addProperty("HostInstanceId", hostInstanceId);
        }
        if ((liveLogsSessionId = (String)attributes.get(AiSemanticAttributes.AZ_FN_LIVE_LOGS_SESSION_ID)) != null) {
            telemetryBuilder.addProperty("#AzFuncLiveLogsSessionId", liveLogsSessionId);
        }
    }

    private void setLoggerProperties(AbstractTelemetryBuilder telemetryBuilder, @Nullable String loggerName, @Nullable String threadName, Severity severity) {
        String loggingLevel;
        telemetryBuilder.addProperty("SourceType", "Logger");
        if (this.captureLoggingLevelAsCustomDimension && (loggingLevel = LogDataMapper.mapSeverityToLoggingLevel(severity)) != null) {
            telemetryBuilder.addProperty("LoggingLevel", loggingLevel);
        }
        if (loggerName != null) {
            telemetryBuilder.addProperty("LoggerName", loggerName);
        }
        if (threadName != null) {
            telemetryBuilder.addProperty("ThreadName", threadName);
        }
    }

    @Nullable
    private static SeverityLevel toSeverityLevel(Severity severity) {
        switch (severity) {
            case UNDEFINED_SEVERITY_NUMBER: 
            case TRACE: 
            case TRACE2: 
            case TRACE3: 
            case TRACE4: 
            case DEBUG: 
            case DEBUG2: 
            case DEBUG3: 
            case DEBUG4: {
                return SeverityLevel.VERBOSE;
            }
            case INFO: 
            case INFO2: 
            case INFO3: 
            case INFO4: {
                return SeverityLevel.INFORMATION;
            }
            case WARN: 
            case WARN2: 
            case WARN3: 
            case WARN4: {
                return SeverityLevel.WARNING;
            }
            case ERROR: 
            case ERROR2: 
            case ERROR3: 
            case ERROR4: {
                return SeverityLevel.ERROR;
            }
            case FATAL: 
            case FATAL2: 
            case FATAL3: 
            case FATAL4: {
                return SeverityLevel.CRITICAL;
            }
        }
        return SeverityLevel.VERBOSE;
    }

    @Nullable
    private static String mapSeverityToLoggingLevel(Severity severity) {
        switch (severity) {
            case UNDEFINED_SEVERITY_NUMBER: {
                return null;
            }
            case FATAL: 
            case FATAL2: 
            case FATAL3: 
            case FATAL4: {
                return "FATAL";
            }
            case ERROR: 
            case ERROR2: 
            case ERROR3: 
            case ERROR4: {
                return "ERROR";
            }
            case WARN: 
            case WARN2: 
            case WARN3: 
            case WARN4: {
                return "WARN";
            }
            case INFO: 
            case INFO2: 
            case INFO3: 
            case INFO4: {
                return "INFO";
            }
            case DEBUG: 
            case DEBUG2: 
            case DEBUG3: 
            case DEBUG4: {
                return "DEBUG";
            }
            case TRACE: 
            case TRACE2: 
            case TRACE3: 
            case TRACE4: {
                return "TRACE";
            }
        }
        logger.error("Unexpected severity {}", new Object[]{severity});
        return null;
    }

    static {
        MappingsBuilder mappingsBuilder = new MappingsBuilder(MappingsBuilder.MappingType.LOG).prefix(LOG4J_MDC_PREFIX, (telemetryBuilder, key, value) -> telemetryBuilder.addProperty(key.substring(LOG4J_MDC_PREFIX.length()), String.valueOf(value))).prefix(LOG4J_CONTEXT_DATA_PREFIX, (telemetryBuilder, key, value) -> telemetryBuilder.addProperty(key.substring(LOG4J_CONTEXT_DATA_PREFIX.length()), String.valueOf(value))).prefix(LOGBACK_MDC_PREFIX, (telemetryBuilder, key, value) -> telemetryBuilder.addProperty(key.substring(LOGBACK_MDC_PREFIX.length()), String.valueOf(value))).prefix(JBOSS_LOGGING_MDC_PREFIX, (telemetryBuilder, key, value) -> telemetryBuilder.addProperty(key.substring(JBOSS_LOGGING_MDC_PREFIX.length()), String.valueOf(value))).prefix(LOG4J_MAP_MESSAGE_PREFIX, (telemetryBuilder, key, value) -> telemetryBuilder.addProperty(key.substring(LOG4J_MAP_MESSAGE_PREFIX.length()), String.valueOf(value))).exactString(SemanticAttributes.CODE_FILEPATH, "FileName").exactString(SemanticAttributes.CODE_NAMESPACE, "ClassName").exactString(SemanticAttributes.CODE_FUNCTION, "MethodName").exactLong(SemanticAttributes.CODE_LINENO, "LineNumber").exactString(LOG4J_MARKER, "Marker").exactStringArray(LOGBACK_MARKER, "Marker");
        SpanDataMapper.applyCommonTags(mappingsBuilder);
        MAPPINGS = mappingsBuilder.build();
    }
}

