/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation;

import java.util.concurrent.ThreadLocalRandom;
import reactor.util.annotation.Nullable;

public class SamplingScoreGeneratorV2 {
    public static double getSamplingScore(@Nullable String operationId) {
        if (operationId != null && !operationId.isEmpty()) {
            return 100.0 * ((double)SamplingScoreGeneratorV2.getSamplingHashCode(operationId) / 2.147483647E9);
        }
        return 100.0 * ThreadLocalRandom.current().nextDouble();
    }

    private static int getSamplingHashCode(String operationId) {
        CharSequence opId;
        if (operationId.length() < 8) {
            StringBuilder opIdBuilder = new StringBuilder(operationId);
            while (opIdBuilder.length() < 8) {
                opIdBuilder.append(operationId);
            }
            opId = opIdBuilder;
        } else {
            opId = operationId;
        }
        int hash = 5381;
        for (int i = 0; i < opId.length(); ++i) {
            hash = (hash << 5) + hash + opId.charAt(i);
        }
        if (hash == Integer.MIN_VALUE || hash == Integer.MAX_VALUE) {
            return 0x7FFFFFFE;
        }
        return Math.abs(hash);
    }

    private SamplingScoreGeneratorV2() {
    }
}

