/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.builders;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.StatsbeatConnectionString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MonitorBase;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MonitorDomain;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryItem;
import io.opentelemetry.sdk.resources.Resource;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public abstract class AbstractTelemetryBuilder {
    private static final int MAX_PROPERTY_KEY_LENGTH = 150;
    private static final int MAX_PROPERTY_VALUE_LENGTH = 8192;
    protected static final int MAX_MEASUREMENT_KEY_LENGTH = 150;
    protected static final int MAX_NAME_LENGTH = 1024;
    protected static final int MAX_ID_LENGTH = 512;
    private final TelemetryItem telemetryItem = new TelemetryItem();

    protected AbstractTelemetryBuilder(MonitorDomain data, String telemetryName, String baseType) {
        this.telemetryItem.setVersion(1);
        this.telemetryItem.setName(telemetryName);
        data.setVersion(2);
        MonitorBase monitorBase = new MonitorBase();
        this.telemetryItem.setData(monitorBase);
        monitorBase.setBaseType(baseType);
        monitorBase.setBaseData(data);
    }

    public void setTime(OffsetDateTime time) {
        this.telemetryItem.setTime(time);
    }

    public void setSampleRate(float sampleRate) {
        this.telemetryItem.setSampleRate(Float.valueOf(sampleRate));
    }

    public void setConnectionString(String connectionString) {
        this.telemetryItem.setConnectionString(connectionString);
    }

    public void setConnectionString(ConnectionString connectionString) {
        this.telemetryItem.setConnectionString(connectionString);
    }

    public void setConnectionString(StatsbeatConnectionString connectionString) {
        this.telemetryItem.setConnectionString(connectionString);
    }

    public void setResource(Resource resource) {
        this.telemetryItem.setResource(resource);
    }

    public void addTag(String key, String value) {
        Map<String, String> tags = this.telemetryItem.getTags();
        if (tags == null) {
            tags = new HashMap<String, String>();
            this.telemetryItem.setTags(tags);
        }
        tags.put(key, value);
    }

    public void addProperty(@Nullable String key, @Nullable String value) {
        if (key == null || key.isEmpty() || key.length() > 150 || value == null) {
            return;
        }
        this.getProperties().put(key, TelemetryTruncation.truncatePropertyValue(value, 8192, key));
    }

    public TelemetryItem build() {
        return this.telemetryItem;
    }

    protected abstract Map<String, String> getProperties();
}

