/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.builders;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.AvailabilityData;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class AvailabilityTelemetryBuilder
extends AbstractTelemetryBuilder {
    private static final int MAX_RUN_LOCATION_LENGTH = 1024;
    private static final int MAX_MESSAGE_LENGTH = 8192;
    private final AvailabilityData data;

    public static AvailabilityTelemetryBuilder create() {
        return new AvailabilityTelemetryBuilder(new AvailabilityData());
    }

    private AvailabilityTelemetryBuilder(AvailabilityData data) {
        super(data, "Availability", "AvailabilityData");
        this.data = data;
    }

    public void setId(String id) {
        this.data.setId(TelemetryTruncation.truncateTelemetry(id, 512, "Availability.id"));
    }

    public void setName(String name) {
        this.data.setName(TelemetryTruncation.truncateTelemetry(name, 1024, "Availability.name"));
    }

    public void setDuration(String duration) {
        this.data.setDuration(duration);
    }

    public void setSuccess(boolean success) {
        this.data.setSuccess(success);
    }

    public void setRunLocation(String runLocation) {
        this.data.setRunLocation(TelemetryTruncation.truncateTelemetry(runLocation, 1024, "Availability.runLocation"));
    }

    public void setMessage(String message) {
        this.data.setMessage(TelemetryTruncation.truncateTelemetry(message, 8192, "Availability.message"));
    }

    public void addMeasurement(@Nullable String key, Double value) {
        if (key == null || key.isEmpty() || key.length() > 150) {
            return;
        }
        Map<String, Double> measurements = this.data.getMeasurements();
        if (measurements == null) {
            measurements = new HashMap<String, Double>();
            this.data.setMeasurements(measurements);
        }
        measurements.put(key, value);
    }

    @Override
    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.data.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            this.data.setProperties(properties);
        }
        return properties;
    }
}

