/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.builders;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryEventData;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class EventTelemetryBuilder
extends AbstractTelemetryBuilder {
    private static final int MAX_EVENT_NAME_LENGTH = 512;
    private final TelemetryEventData data;

    public static EventTelemetryBuilder create() {
        return new EventTelemetryBuilder(new TelemetryEventData());
    }

    private EventTelemetryBuilder(TelemetryEventData data) {
        super(data, "Event", "EventData");
        this.data = data;
    }

    public void setName(String name) {
        this.data.setName(TelemetryTruncation.truncateTelemetry(name, 512, "Event.name"));
    }

    public void addMeasurement(@Nullable String key, Double value) {
        if (key == null || key.isEmpty() || key.length() > 150) {
            return;
        }
        Map<String, Double> measurements = this.data.getMeasurements();
        if (measurements == null) {
            measurements = new HashMap<String, Double>();
            this.data.setMeasurements(measurements);
        }
        measurements.put(key, value);
    }

    @Override
    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.data.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            this.data.setProperties(properties);
        }
        return properties;
    }
}

