/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.builders;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MetricDataPoint;

public final class MetricPointBuilder {
    private static final int MAX_METRIC_NAME_SPACE_LENGTH = 256;
    private static final int MAX_NAME_LENGTH = 1024;
    private final MetricDataPoint data = new MetricDataPoint();

    public void setNamespace(String namespace) {
        this.data.setNamespace(TelemetryTruncation.truncateTelemetry(namespace, 256, "MetricPoint.namespace"));
    }

    public void setName(String name) {
        this.data.setName(TelemetryTruncation.truncateTelemetry(name, 1024, "MetricPoint.name"));
    }

    public void setValue(double value) {
        this.data.setValue(value);
    }

    public void setCount(Integer count) {
        this.data.setCount(count);
    }

    public void setMin(Double min) {
        this.data.setMin(min);
    }

    public void setMax(Double max) {
        this.data.setMax(max);
    }

    public void setStdDev(Double stdDev) {
        this.data.setStdDev(stdDev);
    }

    MetricDataPoint build() {
        return this.data;
    }
}

