/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.builders;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.StackFrame;

public final class StackFrameBuilder {
    private static final int MAX_FILE_NAME_LENGTH = 1024;
    private static final int MAX_METHOD_NAME_LENGTH = 1024;
    private static final int MAX_ASSEMBLY_NAME_LENGTH = 1024;
    private final StackFrame data = new StackFrame();

    public void setLevel(int level) {
        this.data.setLevel(level);
    }

    public void setMethod(String method) {
        this.data.setMethod(TelemetryTruncation.truncateTelemetry(method, 1024, "StackFrame.method"));
    }

    public void setAssembly(String assembly) {
        this.data.setAssembly(TelemetryTruncation.truncateTelemetry(assembly, 1024, "StackFrame.assembly"));
    }

    public void setFileName(String fileName) {
        this.data.setFileName(TelemetryTruncation.truncateTelemetry(fileName, 1024, "StackFrame.fileName"));
    }

    public void setLine(Integer line) {
        this.data.setLine(line);
    }

    StackFrame build() {
        return this.data;
    }
}

