/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.builders;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.AzureMonitorMsgId;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.MDC;
import reactor.util.annotation.Nullable;

final class TelemetryTruncation {
    private static final ClientLogger logger = new ClientLogger(TelemetryTruncation.class);
    private static final Set<String> alreadyLoggedAttributeNames = ConcurrentHashMap.newKeySet();
    private static final Set<String> alreadyLoggedPropertyKeys = ConcurrentHashMap.newKeySet();

    static String truncateTelemetry(@Nullable String value, int maxLength, String attributeName) {
        if (value == null || value.length() <= maxLength) {
            return value;
        }
        if (alreadyLoggedAttributeNames.add(attributeName)) {
            try (MDC.MDCCloseable ignored = AzureMonitorMsgId.TELEMETRY_TRUNCATION_ERROR.makeActive();){
                logger.warning("truncated {} attribute value to {} characters (this message will only be logged once per attribute name): {}", new Object[]{attributeName, maxLength, TelemetryTruncation.trimTo80(value)});
            }
        }
        logger.verbose("truncated {} attribute value to {} characters: {}", new Object[]{attributeName, maxLength, value});
        return value.substring(0, maxLength);
    }

    static String truncatePropertyValue(@Nullable String value, int maxLength, String propertyKey) {
        if (value == null || value.length() <= maxLength) {
            return value;
        }
        if (alreadyLoggedPropertyKeys.size() < 10 && alreadyLoggedPropertyKeys.add(propertyKey)) {
            try (MDC.MDCCloseable ignored = AzureMonitorMsgId.TELEMETRY_TRUNCATION_ERROR.makeActive();){
                logger.warning("truncated {} property value to {} characters (this message will only be logged once per property key, and only for at most 10 different property keys): {}", new Object[]{propertyKey, maxLength, TelemetryTruncation.trimTo80(value)});
            }
        }
        logger.verbose("truncated {} property value to {} characters: {}", new Object[]{propertyKey, maxLength, value});
        return value.substring(0, maxLength);
    }

    private static String trimTo80(String value) {
        if (value.length() <= 80) {
            return value;
        }
        return value.substring(0, 80) + "...";
    }

    private TelemetryTruncation() {
    }
}

