/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.heartbeat;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.MetricTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.heartbeat.HeartBeatPropertyPayload;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.heartbeat.HeartbeatDefaultPayload;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.ThreadPoolUtils;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class HeartbeatExporter {
    private static final ClientLogger logger = new ClientLogger(HeartbeatExporter.class);
    private static final String HEARTBEAT_SYNTHETIC_METRIC_NAME = "HeartbeatState";
    private final ConcurrentMap<String, HeartBeatPropertyPayload> heartbeatProperties = new ConcurrentHashMap<String, HeartBeatPropertyPayload>();
    private final Consumer<List<TelemetryItem>> telemetryItemsConsumer;
    private final BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer;
    private final ExecutorService propertyUpdateService = Executors.newCachedThreadPool(ThreadPoolUtils.createDaemonThreadFactory(HeartbeatExporter.class, "propertyUpdateService"));
    private final ScheduledExecutorService heartBeatSenderService = Executors.newSingleThreadScheduledExecutor(ThreadPoolUtils.createDaemonThreadFactory(HeartbeatExporter.class, "heartBeatSenderService"));

    public static void start(long intervalSeconds, BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer, Consumer<List<TelemetryItem>> telemetryItemsConsumer) {
        new HeartbeatExporter(intervalSeconds, telemetryInitializer, telemetryItemsConsumer);
    }

    public HeartbeatExporter(long intervalSeconds, BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer, Consumer<List<TelemetryItem>> telemetryItemsConsumer) {
        this.telemetryItemsConsumer = telemetryItemsConsumer;
        this.telemetryInitializer = telemetryInitializer;
        this.propertyUpdateService.execute(HeartbeatDefaultPayload.populateDefaultPayload(this));
        this.heartBeatSenderService.scheduleAtFixedRate(this::send, intervalSeconds, intervalSeconds, TimeUnit.SECONDS);
    }

    public boolean addHeartBeatProperty(String propertyName, String propertyValue, boolean isHealthy) {
        if (this.heartbeatProperties.containsKey(propertyName)) {
            logger.verbose("heartbeat property {} cannot be added twice. Please use setHeartBeatProperty instead to modify the value", new Object[]{propertyName});
            return false;
        }
        HeartBeatPropertyPayload payload = new HeartBeatPropertyPayload();
        payload.setHealthy(isHealthy);
        payload.setPayloadValue(propertyValue);
        this.heartbeatProperties.put(propertyName, payload);
        return true;
    }

    private void send() {
        try {
            this.telemetryItemsConsumer.accept(Collections.singletonList(this.gatherData()));
        }
        catch (RuntimeException e) {
            logger.warning("Error occured while sending heartbeat");
        }
    }

    TelemetryItem gatherData() {
        HashMap<String, String> properties = new HashMap<String, String>();
        double numHealthy = 0.0;
        for (Map.Entry entry : this.heartbeatProperties.entrySet()) {
            HeartBeatPropertyPayload payload = (HeartBeatPropertyPayload)entry.getValue();
            properties.put((String)entry.getKey(), payload.getPayloadValue());
            numHealthy += payload.isHealthy() ? 0.0 : 1.0;
        }
        MetricTelemetryBuilder telemetryBuilder = MetricTelemetryBuilder.create(HEARTBEAT_SYNTHETIC_METRIC_NAME, numHealthy);
        this.telemetryInitializer.accept(telemetryBuilder, Resource.empty());
        telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_SYNTHETIC_SOURCE.toString(), HEARTBEAT_SYNTHETIC_METRIC_NAME);
        for (Map.Entry entry : properties.entrySet()) {
            telemetryBuilder.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return telemetryBuilder.build();
    }
}

