/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.logging;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.logging.NetworkFriendlyExceptions;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.Response;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryPipeline;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryPipelineRequest;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryPipelineResponse;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.AzureMonitorMsgId;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class DiagnosticTelemetryPipelineListener
implements TelemetryPipelineListener {
    private static final Class<?> FOR_CLASS = TelemetryPipeline.class;
    private static final ClientLogger logger = new ClientLogger(FOR_CLASS);
    private static final AtomicBoolean friendlyExceptionThrown = new AtomicBoolean();
    private final OperationLogger operationLogger;
    private final boolean logRetryableFailures;
    private final String retryableFailureSuffix;

    public DiagnosticTelemetryPipelineListener(String operation, boolean logRetryableFailures, String retryableFailureSuffix) {
        this.operationLogger = new OperationLogger(FOR_CLASS, operation);
        this.logRetryableFailures = logRetryableFailures;
        this.retryableFailureSuffix = retryableFailureSuffix;
    }

    @Override
    public void onResponse(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
        int responseCode = response.getStatusCode();
        switch (responseCode) {
            case 200: {
                this.operationLogger.recordSuccess();
                break;
            }
            case 206: 
            case 400: {
                Set<String> errors = response.getErrorMessages();
                if (errors.isEmpty()) break;
                this.operationLogger.recordFailure("Received response code " + responseCode + " (" + String.join((CharSequence)", ", errors) + ")", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 307: 
            case 308: {
                this.operationLogger.recordFailure("Too many redirects", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 401: 
            case 403: {
                if (!this.logRetryableFailures) break;
                this.operationLogger.recordFailure(DiagnosticTelemetryPipelineListener.getErrorMessageFromCredentialRelatedResponse(responseCode, response.getBody()), AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 408: 
            case 429: 
            case 500: 
            case 502: 
            case 503: 
            case 504: {
                if (!this.logRetryableFailures) break;
                this.operationLogger.recordFailure("Received response code " + responseCode + this.retryableFailureSuffix, AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 402: {
                this.operationLogger.recordFailure("Received response code 402 (daily quota exceeded and throttled over extended time)", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 439: {
                this.operationLogger.recordFailure("Received response code 439 (daily quota exceeded and throttled over extended time)", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            default: {
                this.operationLogger.recordFailure("received response code: " + responseCode, AzureMonitorMsgId.INGESTION_ERROR);
            }
        }
    }

    @Override
    public void onException(TelemetryPipelineRequest request, String reason, Throwable throwable) {
        if (!NetworkFriendlyExceptions.logSpecialOneTimeFriendlyException(throwable, request.getUrl().toString(), friendlyExceptionThrown, logger) && this.logRetryableFailures) {
            this.operationLogger.recordFailure(reason + this.retryableFailureSuffix, throwable, AzureMonitorMsgId.INGESTION_ERROR);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    public static String getErrorMessageFromCredentialRelatedResponse(int responseCode, String responseBody) {
        String message = null;
        try (JsonReader jsonReader = JsonProviders.createReader((String)responseBody);){
            Response response = Response.fromJson(jsonReader);
            if (response.getErrors() != null && !response.getErrors().isEmpty()) {
                message = response.getErrors().get(0).getMessage();
            }
        }
        catch (IOException e) {
            return "Ingestion service returned " + responseCode + ", but could not parse response as json: " + responseBody;
        }
        String action = responseCode == 401 ? ". Please provide Azure Active Directory credentials" : ". Please check your Azure Active Directory credentials, they might be incorrect or expired";
        return message + action + " (telemetry will be stored to disk and retried)";
    }
}

