/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.logging;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.logging.AggregatingLogger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

public class WarningLogger {
    private final Logger logger;
    private final String message;
    private final AtomicLong numWarnings = new AtomicLong();
    private final int intervalSeconds;
    private final AtomicBoolean firstFailure = new AtomicBoolean();

    public WarningLogger(Class<?> source, String message) {
        this(source, message, 300);
    }

    WarningLogger(Class<?> source, String message, int intervalSeconds) {
        this.logger = LoggerFactory.getLogger(source);
        this.message = message;
        this.intervalSeconds = intervalSeconds;
    }

    public void recordWarning() {
        this.recordWarning(null);
    }

    public void recordWarning(@Nullable Throwable exception) {
        if (!this.firstFailure.getAndSet(true)) {
            this.logger.warn("{} (future warnings will be aggregated and logged once every {} minutes)", new Object[]{this.message, this.intervalSeconds / 60, exception});
            AggregatingLogger.scheduledExecutor.scheduleWithFixedDelay(new ExceptionStatsLogger(), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
            return;
        }
        this.logger.debug(this.message, exception);
        this.numWarnings.incrementAndGet();
    }

    private class ExceptionStatsLogger
    implements Runnable {
        private ExceptionStatsLogger() {
        }

        @Override
        public void run() {
            long numWarnings = WarningLogger.this.numWarnings.getAndSet(0L);
            if (numWarnings == 0L) {
                return;
            }
            long numMinutes = WarningLogger.this.intervalSeconds / 60;
            WarningLogger.this.logger.warn("In the last {} minutes, the following warning has occurred {} times: {}", new Object[]{numMinutes, numWarnings, WarningLogger.this.message});
        }
    }
}

