/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MetricDataPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MonitorDomain;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MetricsData
extends MonitorDomain {
    private List<MetricDataPoint> metrics;
    private Map<String, String> properties;

    public List<MetricDataPoint> getMetrics() {
        return this.metrics;
    }

    public MetricsData setMetrics(List<MetricDataPoint> metrics) {
        this.metrics = metrics;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public MetricsData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public MetricsData setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ver", this.getVersion());
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MetricsData fromJson(JsonReader jsonReader) throws IOException {
        return (MetricsData)jsonReader.readObject(reader -> {
            MetricsData deserializedMetricsData = new MetricsData();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ver".equals(fieldName)) {
                    deserializedMetricsData.setVersion(reader.getInt());
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    List metrics;
                    deserializedMetricsData.metrics = metrics = reader.readArray(reader1 -> MetricDataPoint.fromJson(reader1));
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedMetricsData.properties = properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMetricsData.setAdditionalProperties(additionalProperties);
            return deserializedMetricsData;
        });
    }
}

