/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MonitorDomain;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RequestData
extends MonitorDomain {
    private String id;
    private String name;
    private String duration;
    private boolean success;
    private String responseCode;
    private String source;
    private String url;
    private Map<String, String> properties;
    private Map<String, Double> measurements;

    public String getId() {
        return this.id;
    }

    public RequestData setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RequestData setName(String name) {
        this.name = name;
        return this;
    }

    public String getDuration() {
        return this.duration;
    }

    public RequestData setDuration(String duration) {
        this.duration = duration;
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public RequestData setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public RequestData setResponseCode(String responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public RequestData setSource(String source) {
        this.source = source;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public RequestData setUrl(String url) {
        this.url = url;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public RequestData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Double> getMeasurements() {
        return this.measurements;
    }

    public RequestData setMeasurements(Map<String, Double> measurements) {
        this.measurements = measurements;
        return this;
    }

    @Override
    public RequestData setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ver", this.getVersion());
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("duration", this.duration);
        jsonWriter.writeBooleanField("success", this.success);
        jsonWriter.writeStringField("responseCode", this.responseCode);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("measurements", this.measurements, (writer, element) -> writer.writeDouble(element.doubleValue()));
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RequestData fromJson(JsonReader jsonReader) throws IOException {
        return (RequestData)jsonReader.readObject(reader -> {
            RequestData deserializedRequestData = new RequestData();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ver".equals(fieldName)) {
                    deserializedRequestData.setVersion(reader.getInt());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRequestData.id = reader.getString();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedRequestData.duration = reader.getString();
                    continue;
                }
                if ("success".equals(fieldName)) {
                    deserializedRequestData.success = reader.getBoolean();
                    continue;
                }
                if ("responseCode".equals(fieldName)) {
                    deserializedRequestData.responseCode = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRequestData.name = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedRequestData.source = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedRequestData.url = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedRequestData.properties = properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("measurements".equals(fieldName)) {
                    Map measurements;
                    deserializedRequestData.measurements = measurements = reader.readMap(reader1 -> reader1.getDouble());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRequestData.setAdditionalProperties(additionalProperties);
            return deserializedRequestData;
        });
    }
}

