/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.AppInsightsByteBufferPool;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteBufferOutputStream
extends OutputStream {
    private final AppInsightsByteBufferPool byteBufferPool;
    private final List<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>();
    private ByteBuffer current;

    public ByteBufferOutputStream(AppInsightsByteBufferPool byteBufferPool) {
        this.byteBufferPool = byteBufferPool;
        this.current = byteBufferPool.remove();
        this.byteBuffers.add(this.current);
    }

    @Override
    public void write(int b) {
        this.ensureSomeCapacity();
        this.current.put((byte)b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.ensureSomeCapacity();
        int numBytesWritten = Math.min(this.current.remaining(), len);
        this.current.put(bytes, off, numBytesWritten);
        if (numBytesWritten < len) {
            this.write(bytes, off + numBytesWritten, len - numBytesWritten);
        }
    }

    void ensureSomeCapacity() {
        if (this.current.remaining() > 0) {
            return;
        }
        this.current = this.byteBufferPool.remove();
        this.byteBuffers.add(this.current);
    }

    public List<ByteBuffer> getByteBuffers() {
        return this.byteBuffers;
    }
}

