/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;

public class TelemetryPipelineRequest {
    private volatile URL url;
    private final String connectionString;
    private final String instrumentationKey;
    private final List<ByteBuffer> byteBuffers;
    private final int contentLength;

    TelemetryPipelineRequest(URL url, String connectionString, String instrumentationKey, List<ByteBuffer> byteBuffers) {
        this.url = url;
        this.connectionString = connectionString;
        this.instrumentationKey = instrumentationKey;
        this.byteBuffers = byteBuffers;
        this.contentLength = byteBuffers.stream().mapToInt(Buffer::limit).sum();
    }

    public URL getUrl() {
        return this.url;
    }

    void setUrl(URL url) {
        this.url = url;
    }

    public List<ByteBuffer> getByteBuffers() {
        return this.byteBuffers;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    HttpRequest createHttpRequest() {
        HttpRequest request = new HttpRequest(HttpMethod.POST, this.url);
        request.setBody(Flux.fromIterable(this.byteBuffers));
        request.setHeader(HttpHeaderName.CONTENT_LENGTH, Integer.toString(this.contentLength));
        request.setHeader(HttpHeaderName.USER_AGENT, "");
        request.setHeader(HttpHeaderName.CONTENT_ENCODING, "gzip");
        return request;
    }
}

